//                                               -*- C++ -*-
/**
 *  @file  RandomDirection.cxx
 *  @brief
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: RandomDirection.cxx 1866 2011-04-11 10:32:27Z schueller $
 */
#include "RandomDirection.hxx"

namespace OpenTURNS
{

  namespace Uncertainty
  {

    namespace Algorithm
    {

      /**
       * @class RandomDirection
       */

      CLASSNAMEINIT(RandomDirection);

      /* Default constructor */
      RandomDirection::RandomDirection():
        SamplingStrategyImplementation(0)
      {
        // Nothing to do
      }

      /* Constructor with parameters */
      RandomDirection::RandomDirection(const UnsignedLong dimension):
        SamplingStrategyImplementation(dimension)
      {
        // Nothing to do
      }

      /* Virtual constructor */
      RandomDirection * RandomDirection::clone() const
      {
        return new RandomDirection(*this);
      }

      /* Generate a set of directions */
      RandomDirection::NumericalSample RandomDirection::generate() const
      {
        NumericalSample result(2, dimension_);
        result[0] = getUniformUnitVectorRealization();
        result[1] = -1.0 * result[0];
        return result;
      }

      /* String converter */
      String RandomDirection::__repr__() const
      {
        OSS oss;
        oss << "class=" << RandomDirection::GetClassName()
            << " derived from " << SamplingStrategyImplementation::__repr__();
        return oss;
      }

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

