//                                               -*- C++ -*-
/**
 *  @file  SimulationResult.cxx
 *  @brief SimulationResult stores the simulation result
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2008-05-23 13:46:12 +0200 (ven, 23 mai 2008) $
 *  Id:      $Id: SimulationResult.cxx 821 2008-05-23 11:46:12Z schueller $
 */
#include <cmath>
#include "SimulationResult.hxx"
#include "DistFunc.hxx"

namespace OpenTURNS
{

  namespace Uncertainty
  {

    namespace Algorithm
    {

      typedef Uncertainty::Distribution::DistFunc DistFunc;

      CLASSNAMEINIT(SimulationResult);

      /* Default constructor */
      SimulationResult::SimulationResult()
        : Base::Common::TypedInterfaceObject<SimulationResultImplementation>(SimulationResultImplementation().clone())
      {
        // Nothing to do
      }

      /* Standard constructor */
      SimulationResult::SimulationResult(const Event & event,
                                         const NumericalScalar probabilityEstimate,
                                         const NumericalScalar varianceEstimate,
                                         const UnsignedLong outerSampling,
                                         const UnsignedLong blockSize,
                                         const NumericalPoint & meanPointInEventDomain) /* throw(InvalidArgumentException) */
        : Base::Common::TypedInterfaceObject<SimulationResultImplementation>(new SimulationResultImplementation(event, probabilityEstimate, varianceEstimate, outerSampling, blockSize, meanPointInEventDomain))
      {
        // Nothing to do
      }

      /* Constructor with parameters */
      SimulationResult::SimulationResult(Implementation & p_implementation)
        : Base::Common::TypedInterfaceObject<SimulationResultImplementation>(p_implementation)
      {
        // Nothing to do
      }

      /* Constructor with parameters */
      SimulationResult::SimulationResult(const SimulationResultImplementation & implementation)
        : Base::Common::TypedInterfaceObject<SimulationResultImplementation>(implementation.clone())
      {
        // Nothing to do
      }

      /* Event accessor */
      SimulationResult::Event SimulationResult::getEvent() const
      {
        return getImplementation()->getEvent();
      }

      /* Probability estimate accessor */
      NumericalScalar SimulationResult::getProbabilityEstimate() const
      {
        return getImplementation()->getProbabilityEstimate();
      }

      void SimulationResult::setProbabilityEstimate(const NumericalScalar probabilityEstimate)
      {
        getImplementation()->setProbabilityEstimate(probabilityEstimate);
      }

      /* Variance estimate accessor */
      NumericalScalar SimulationResult::getVarianceEstimate() const
      {
        return getImplementation()->getVarianceEstimate();
      }

      void SimulationResult::setVarianceEstimate(const NumericalScalar varianceEstimate)
      {
        getImplementation()->setVarianceEstimate(varianceEstimate);
      }

      /* Variance estimate accessor */
      SimulationResult::NumericalPoint SimulationResult::getMeanPointInEventDomain() const
      {
        return getImplementation()->getMeanPointInEventDomain();
      }

      void SimulationResult::setMeanPointInEventDomain(const NumericalPoint & meanPointInEventDomain)
      {
        getImplementation()->setMeanPointInEventDomain(meanPointInEventDomain);
      }

      /* Coefficient of variation estimate accessor */
      NumericalScalar SimulationResult::getCoefficientOfVariation() const
      {
        return getImplementation()->getCoefficientOfVariation();
      }

      /* Standard deviation estimate accessor */
      NumericalScalar SimulationResult::getStandardDeviation() const
      {
        return getImplementation()->getStandardDeviation();
      }

      /* Outer sampling accessor */
      UnsignedLong SimulationResult::getOuterSampling() const
      {
        return getImplementation()->getOuterSampling();
      }

      void SimulationResult::setOuterSampling(const UnsignedLong outerSampling)
      {
        getImplementation()->setOuterSampling(outerSampling);
      }

      /* String converter */
      String SimulationResult::__repr__() const
      {
        return getImplementation()->__repr__();
      }

      /* Confidence length */
      NumericalScalar SimulationResult::getConfidenceLength(const NumericalScalar level) const
      /* throw(InvalidArgumentException) */
      {
        return getImplementation()->getConfidenceLength();
      }

      /* Block size accessor */
      UnsignedLong SimulationResult::getBlockSize() const
      {
        return getImplementation()->getBlockSize();
      }

      void SimulationResult::setBlockSize(const UnsignedLong blockSize)
      {
        getImplementation()->setBlockSize(blockSize);
      }

      /* Importance factors accessor */
      SimulationResult::NumericalPointWithDescription SimulationResult::getImportanceFactors() const
      {
        return getImplementation()->getImportanceFactors();
      }

      /* Draw the importance factors */
      SimulationResult::Graph SimulationResult::drawImportanceFactors() const
      {
        return getImplementation()->drawImportanceFactors();
      }

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
