//                                               -*- C++ -*-
/**
 *  @file  DirichletFactory.hxx
 *  @brief Factory for Dirichlet distribution
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2011-01-12 22:41:37 +0100 (mer. 12 janv. 2011) $
 *  Id:      $Id: DirichletFactory.hxx 1692 2011-01-12 21:41:37Z lebrun $
 */
#ifndef OPENTURNS_DIRICHLETFACTORY_HXX
#define OPENTURNS_DIRICHLETFACTORY_HXX

#include "OTprivate.hxx"
#include "DistributionImplementationFactory.hxx"
#include "Dirichlet.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Distribution {

      /**
       * @class DirichletFactory
       */
      class DirichletFactory
        : public Model::DistributionImplementationFactory
      {
      public:

        // Default absolute precision of the computation
        static const NumericalScalar ParametersEpsilon;
        static const UnsignedLong MaximumIteration;

        typedef Model::DistributionImplementationFactory                    DistributionImplementationFactory; // required by SWIG
        typedef DistributionImplementationFactory::NumericalSample          NumericalSample;
        typedef DistributionImplementationFactory::InternalException        InternalException;
        typedef DistributionImplementationFactory::InvalidArgumentException InvalidArgumentException;

        /** Default constructor */
        DirichletFactory();

        /** Virtual constructor */
        virtual DirichletFactory * clone() const;

        /* Here is the interface that all derived class must implement */
        using DistributionImplementationFactory::build;

        Dirichlet * build(const NumericalSample & sample) const /* throw(InvalidArgumentException, InternalException) */;
        Dirichlet * build(const NumericalPointCollection & parameters) const /* throw(InvalidArgumentException, InternalException) */;
        Dirichlet * build() const /* throw(InvalidArgumentException, InternalException) */;


      }; /* class DirichletFactory */


    } /* namespace Distribution */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_DIRICHLETFACTORY_HXX */
