//                                               -*- C++ -*-
/**
 *  @file  NormalFactory.cxx
 *  @brief Factory for Normal distribution
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-06-30 10:19:34 +0200 (Thu, 30 Jun 2011) $
 *  Id:      $Id: NormalFactory.cxx 1972 2011-06-30 08:19:34Z schueller $
 */
#include <cmath>
#include "NormalFactory.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Distribution {

      typedef Normal::NumericalPoint    NumericalPoint;
      typedef Normal::CorrelationMatrix CorrelationMatrix;
      typedef Normal::CovarianceMatrix  CovarianceMatrix;

      /* Default constructor */
      NormalFactory::NormalFactory():
        DistributionImplementationFactory()
      {
        // Nothing to do
      }

      /* Virtual constructor */
      NormalFactory * NormalFactory::clone() const
      {
        return new NormalFactory(*this);
      }

      /* Here is the interface that all derived class must implement */

      Normal * NormalFactory::build(const NumericalSample & sample) const /* throw(InvalidArgumentException, InternalException) */
      {
        if (sample.getSize() == 0) throw InvalidArgumentException(HERE) << "Error: cannot build a Normal distribution from an empty sample";
        const NumericalPoint mean(sample.computeMean());
        const CovarianceMatrix covariance(sample.computeCovariance());
        return Normal(mean, covariance).clone();
      }

      Normal * NormalFactory::build(const NumericalPointCollection & parameters) const /* throw(InvalidArgumentException, InternalException) */
      {
        try {
          Normal distribution;
          distribution.setParametersCollection(parameters);
          return distribution.clone();
        }
        catch (InvalidArgumentException & ex)
          {
            throw InternalException(HERE) << "Error: cannot build a Normal distribution from the given parameters";
          }
      }

      Normal * NormalFactory::build() const /* throw(InvalidArgumentException, InternalException) */
      {
        return Normal().clone();
      }


    } /* namespace Distribution */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
