//                                               -*- C++ -*-
/**
 *  @file  StudentFactory.cxx
 *  @brief Factory for Student distribution
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-05-24 19:30:41 +0200 (Tue, 24 May 2011) $
 *  Id:      $Id: StudentFactory.cxx 1910 2011-05-24 17:30:41Z schueller $
 */
#include "StudentFactory.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Distribution {

      typedef Model::DistributionImplementationFactory::NumericalPoint NumericalPoint;

      /* Default constructor */
      StudentFactory::StudentFactory():
        DistributionImplementationFactory()
      {
        // Nothing to do
      }

      /* Virtual constructor */
      StudentFactory * StudentFactory::clone() const
      {
        return new StudentFactory(*this);
      }

      /* Here is the interface that all derived class must implement */

      Student * StudentFactory::build(const NumericalSample & sample) const /* throw(InvalidArgumentException, InternalException) */
      {
        if (sample.getSize() == 0) throw InvalidArgumentException(HERE) << "Error: cannot build a Student distribution from an empty sample";
        if (sample.getDimension() != 1) throw InvalidArgumentException(HERE) << "Error: can build a Student distribution only from a sample of dimension 1, here dimension=" << sample.getDimension();
        const NumericalScalar mu(sample.computeMean()[0]);
        const NumericalScalar sigma(sample.computeStandardDeviationPerComponent()[0]);
        const NumericalScalar nu(2.0 + 2.0 / (sigma * sigma - 1.0));
        if (nu <= 2.0) throw InternalException(HERE) << "Error: can build a Student distribution only if nu > 2.0, here nu=" << nu;
        return Student(nu, mu).clone();
      }

      Student * StudentFactory::build() const /* throw(InvalidArgumentException, InternalException) */
      {
        return Student().clone();
      }


    } /* namespace Distribution */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
