//                                               -*- C++ -*-
/**
 *  @file  UserDefinedFactory.cxx
 *  @brief Factory for UserDefined distribution
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-05-24 19:30:41 +0200 (Tue, 24 May 2011) $
 *  Id:      $Id: UserDefinedFactory.cxx 1910 2011-05-24 17:30:41Z schueller $
 */
#include "UserDefinedFactory.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Distribution {

      typedef UserDefined::UserDefinedPairCollection UserDefinedPairCollection;

      /* Default constructor */
      UserDefinedFactory::UserDefinedFactory():
        DistributionImplementationFactory()
      {
        // Nothing to do
      }

      /* Virtual constructor */
      UserDefinedFactory * UserDefinedFactory::clone() const
      {
        return new UserDefinedFactory(*this);
      }


      /* Here is the interface that all derived class must implement */

      UserDefined * UserDefinedFactory::build(const NumericalSample & sample) const /* throw(InvalidArgumentException, InternalException) */
      {
        const UnsignedLong size(sample.getSize());
        if (size == 0) throw InvalidArgumentException(HERE) << "Error: cannot build a UserDefined distribution from an empty sample";
        const NumericalScalar p(1.0 / NumericalScalar(size));
        UserDefinedPairCollection support(size);
        for (UnsignedLong i = 0; i < size; ++i)
          {
            support[i].setX(sample[i]);
            support[i].setP(p);
          }
        return UserDefined(support).clone();
      }

      UserDefined * UserDefinedFactory::build() const /* throw(InvalidArgumentException, InternalException) */
      {
        return UserDefined().clone();
      }


    } /* namespace Distribution */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
