//                                               -*- C++ -*-
/**
 *  @file  t_Pointer_std.cxx
 *  @brief The test file of class Pointer for standard methods
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-05-24 19:30:41 +0200 (Tue, 24 May 2011) $
 *  Id:      $Id: t_Pointer_std.cxx 1910 2011-05-24 17:30:41Z schueller $
 */
#include <iostream>
#include <sstream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "PersistentObject.hxx"
#include "Pointer.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;

class TestClass : public PersistentObject
{
public:
  explicit TestClass(const String & name) : PersistentObject(name)
  {
    //     fullprint << "TestClass(const String & name) ("
    //                << getName() << ")" << std::endl;
  }
  explicit TestClass(const TestClass & other) : PersistentObject(other)
  {
    //     fullprint << "TestClass(const String & name) ("
    //                << getName() << ")" << std::endl;
  }
  virtual ~TestClass()
  {
    //     fullprint << "~TestClass ("
    //                << getName() << ")" << std::endl;
  }
  virtual TestClass * clone() const
  {
    return new TestClass(*this);
  }
};

void printPointer(const Pointer<TestClass> & p)
{
  OStream fullprint(std::cout);

  /** Check pointee accesssor through operator * */
  fullprint << "Object name is : " << (*p).getName() << std::endl;

  /** Check pointee accesssor through operator -> */
  fullprint << "Object name is : " << p->getName() << std::endl;

  /** Is Pointer object uniquely pointing to the pointee */
  fullprint << "Unicity : " << p.unique() << std::endl;

  /** How many Pointer objects do share the pointee */
  fullprint << "Count : " << p.use_count() << std::endl;
}

void printPointee(const Pointer<TestClass> & p)
{
  OStream fullprint(std::cout);

  /** Check operator * */
  fullprint << "p -> " << (*p) << std::endl;
}

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  String name1("One");
  String name2("Two");
  String name3("Three");
  String name4("Four");

  /** Check constructor */
  Pointer<TestClass> p1(new TestClass(name1));
  printPointee(p1);
  printPointer(p1);



  /** Check copy constructor */
  Pointer<TestClass> p2(p1);
  printPointee(p2);
  printPointer(p2);



  /** Check operator = */
  Pointer<TestClass> p3;
  p3 = p1;
  printPointee(p3);
  printPointer(p3);



  /** We try to access pointee by const methods */
  String p3OldName = p3->getName();



  /** Now we change the pointee object (copy-on-write strategy) */
  p3->setName(name2);
  printPointee(p1);
  printPointer(p1);
  printPointee(p2);
  printPointer(p2);
  printPointee(p3);
  printPointer(p3);


  /** Now we reset one Pointer object */
  p2.reset(new TestClass(name3));
  printPointee(p1);
  printPointer(p1);
  printPointee(p2);
  printPointer(p2);
  printPointee(p3);
  printPointer(p3);


  /** Now we reset one Pointer object */
  p2.reset(); // p2 should not be dereferenced until reaffected again
  printPointee(p1);
  printPointer(p1);
  //   printPointee(p2);
  //   printPointer(p2);
  printPointee(p3);
  printPointer(p3);




  /** At last, destructor */

  return ExitCode::Success;
}
