// SWIG file ConfidenceInterval.i
// Author : $LastChangedBy: souchaud $
// Date : $LastChangedDate: 2011-04-05 17:50:07 +0200 (Tue, 05 Apr 2011) $
// Id : $Id: ConfidenceInterval.i 1855 2011-04-05 15:50:07Z souchaud $

%{
#include "ConfidenceInterval.hxx"

namespace OpenTURNS { 

  template <>
  struct traitsPythonType<OpenTURNS::Base::Stat::ConfidenceInterval>
  {
    typedef _PySequence_ Type;
  };

  template <>
  inline
  OpenTURNS::Base::Stat::ConfidenceInterval
  convert<_PySequence_,OpenTURNS::Base::Stat::ConfidenceInterval>(PyObject * pyObj)
  {
    check<_PySequence_>( pyObj );
    PyObject * newPyObj = PySequence_Fast( pyObj, "" );

    if (PySequence_Fast_GET_SIZE( newPyObj ) != 2) 
      throw Base::Common::InvalidArgumentException(HERE) << "Sequence passed as argument is not a pair (NumericalScalar, NumericalScalar)";
    PyObject * item_0 = PySequence_Fast_GET_ITEM( newPyObj, 0 );
    check<_PyFloat_>( item_0 );
    PyObject * item_1 = PySequence_Fast_GET_ITEM( newPyObj, 1 );
    check<_PyFloat_>( item_1 );

    Py_XDECREF( newPyObj );
    return Base::Stat::ConfidenceInterval( convert<_PyFloat_,NumericalScalar>( item_0 ),
			                   convert<_PyFloat_,NumericalScalar>( item_1 ) );
  }


} /* namespace OpenTURNS */

%}

%include ConfidenceInterval.hxx
namespace OpenTURNS{ namespace Base { namespace Stat {

%extend ConfidenceInterval {

ConfidenceInterval(const ConfidenceInterval & other) { return new OpenTURNS::Base::Stat::ConfidenceInterval(other); }

ConfidenceInterval(PyObject * pyObj)
{
 return new OpenTURNS::Base::Stat::ConfidenceInterval( OpenTURNS::convert<OpenTURNS::_PySequence_,OpenTURNS::Base::Stat::ConfidenceInterval>(pyObj) );
}

}

}}}
