// SWIG file TestResult.i
// Author : $LastChangedBy: souchaud $
// Date : $LastChangedDate: 2011-04-05 17:50:07 +0200 (Tue, 05 Apr 2011) $
// Id : $Id: TestResult.i 1855 2011-04-05 15:50:07Z souchaud $

%{
#include "TestResult.hxx"

namespace OpenTURNS { 

  template <>
  struct traitsPythonType<OpenTURNS::Base::Stat::TestResult>
  {
    typedef _PySequence_ Type;
  };

  template <>
  inline
  OpenTURNS::Base::Stat::TestResult
  convert<_PySequence_,OpenTURNS::Base::Stat::TestResult>(PyObject * pyObj)
  {
    check<_PySequence_>( pyObj );
    PyObject * newPyObj = PySequence_Fast( pyObj, "" );

    if (PySequence_Fast_GET_SIZE( newPyObj ) != 4) 
      throw Base::Common::InvalidArgumentException(HERE) << "Sequence passed as argument is not convertible to a TestResult. Expected sequence (String, Bool, NumericalScalar, NumericalScalar)";

    PyObject * item_0 = PySequence_Fast_GET_ITEM( newPyObj, 0 ); check<_PyString_>( item_0 );
    PyObject * item_1 = PySequence_Fast_GET_ITEM( newPyObj, 1 ); check<_PyBool_>( item_1 );
    PyObject * item_2 = PySequence_Fast_GET_ITEM( newPyObj, 2 ); check<_PyFloat_>( item_2 );
    PyObject * item_3 = PySequence_Fast_GET_ITEM( newPyObj, 3 ); check<_PyFloat_>( item_3 );

    Py_XDECREF( newPyObj );
    return OpenTURNS::Base::Stat::TestResult( convert<_PyString_,String>( item_0 ),
                                              convert<_PyBool_,Bool>( item_1 ),
                                              convert<_PyFloat_,NumericalScalar>( item_2 ),
                                              convert<_PyFloat_,NumericalScalar>( item_3 ) );
  }


} /* namespace OpenTURNS */

%}

%include TestResult.hxx
namespace OpenTURNS{ namespace Base { namespace Stat {

%extend TestResult {

TestResult(const TestResult & other) { return new OpenTURNS::Base::Stat::TestResult(other); }

TestResult(PyObject * pyObj)
{
 return new OpenTURNS::Base::Stat::TestResult( OpenTURNS::convert<OpenTURNS::_PySequence_,OpenTURNS::Base::Stat::TestResult>(pyObj) );
}

}
}}}
