// SWIG file base_module.i
// Author : $LastChangedBy: schueller $
// Date : $LastChangedDate: 2011-07-06 12:03:57 +0200 (Wed, 06 Jul 2011) $
// Id : $Id: base_module.i 1991 2011-07-06 10:03:57Z schueller $

%module(package="openturns", docstring="Deterministic meta-package.") base
#pragma SWIG nowarn=314
%feature("autodoc","1");

%pythoncode %{
#from openturns.viewer import ViewImage,StopViewer,WaitForViewer

def TESTPREAMBLE():
  """
  TESTPREAMBLE() catches the --version argument on the command line,
  prints a identification string and then exits softly.
  """
  import sys
  if "--version" in sys.argv:
    print sys.argv[0] + " : $Id: base_module.i 1991 2011-07-06 10:03:57Z schueller $"
    sys.exit(0)
%}

// Use rpy version 2
// Win32 rpy 2 cannot be installed on Linux build machine (Wine)
#if (defined(HAVE_PYTHON_PACKAGE_RPY2) && HAVE_PYTHON_PACKAGE_RPY2) || (defined(HAVE_WIN32) && HAVE_WIN32)
%pythoncode %{
def Show(aGraph):
  from openturns import Graph, GraphImplementation, Drawable, DrawableImplementation
  if (isinstance( aGraph, (Graph, Drawable) )):
    try :
      if (Graph(aGraph).getClassName()=="Graph"):
        import rpy2.robjects as robjects
        tmp=robjects.r(aGraph.getRCommand())
        aGraph.clean()
    except :
      try :
        if (Drawable(aGraph).getClassName()=="Drawable"):
          import rpy2.robjects as robjects
          tmp=robjects.r(aGraph.draw())
          aGraph.clean()
      except :
        import sys
        print "Error in Show", sys.exc_type, sys.exc_value
  else:
    raise ValueError, "Show(): argument is neither a Graph nor a Drawable"
%}
#else /* HAVE_PYTHON_PACKAGE_RPY2 */
%pythoncode %{
def Show(aGraph):
  raise NotImplementedError, "Show() is not available. You need to install rpy2 python module and rebuild Open TURNS to have this work"
%}
#endif /* HAVE_PYTHON_PACKAGE_RPY2 */

%{
#include "OTconfig.hxx"
#include "OT.hxx"
%}

%include typemaps.i
%include OTtypes.i
%include OTexceptions.i
%include std_vector.i

/* Base/Common */
%import common_module.i

/* Wrapper */
%import wrapper_module.i
%import BaseWrapperTemplateDefs.i

/* Base/Type */
%import typ_module.i
%import BaseTypTemplateDefs.i

/* Base/Stat */
%import statistics_module.i
%import BaseStatisticsTemplateDefs.i

/* Base/Graph */
%import graph_module.i
%import BaseGraphTemplateDefs.i

/* Base/Func */
%import func_module.i
%import BaseFuncTemplateDefs.i

/* Base/Diff */
%import diff_module.i
%import BaseDiffTemplateDefs.i

/* Base/Optim */
%import optim_module.i
%import BaseOptimTemplateDefs.i

/* Base/Solver */
%import solver_module.i
%import BaseSolverTemplateDefs.i

/* Base/Algo */
%import algo_module.i
%import BaseAlgoTemplateDefs.i

/* At last we include template definitions */
%include BaseTemplateDefs.i
