//                                               -*- C++ -*-
/**
 *  @file  ImportanceSampling.hxx
 *  @brief ImportanceSampling is an implementation of the importance sampling Montex Carlo simulation method
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: ImportanceSampling.hxx 2392 2012-02-17 18:35:43Z schueller $
 */
#ifndef OPENTURNS_IMPORTANCESAMPLING_HXX
#define OPENTURNS_IMPORTANCESAMPLING_HXX

#include "Simulation.hxx"
#include "Distribution.hxx"

BEGIN_NAMESPACE_OPENTURNS



/**
 * @class ImportanceSampling
 */

class ImportanceSampling :
  public Simulation
{

  CLASSNAME;
public:


  /** Constructor with parameters */
  ImportanceSampling(const Event & event,
                     const Distribution & importanceDistribution);


  /** Virtual constructor */
  virtual ImportanceSampling * clone() const;

  /** Importance distribution accessor */
  Distribution getImportanceDistribution() const;

  /** String converter */
  String __repr__() const;

private:

  /** Compute the block sample */
  NumericalSample computeBlockSample();

  /** Instrumental importance distribution */
  Distribution importanceDistribution_;

} ; /* class ImportanceSampling */

END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_IMPORTANCESAMPLING_HXX */
