//                                               -*- C++ -*-
/**
 *  @file  StudentFactory.cxx
 *  @brief Factory for Student distribution
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: StudentFactory.cxx 2392 2012-02-17 18:35:43Z schueller $
 */
#include "StudentFactory.hxx"

BEGIN_NAMESPACE_OPENTURNS




/* Default constructor */
StudentFactory::StudentFactory():
  DistributionImplementationFactory()
{
  // Nothing to do
}

/* Virtual constructor */
StudentFactory * StudentFactory::clone() const
{
  return new StudentFactory(*this);
}

/* Here is the interface that all derived class must implement */

Student * StudentFactory::build(const NumericalSample & sample) const
{
  if (sample.getSize() == 0) throw InvalidArgumentException(HERE) << "Error: cannot build a Student distribution from an empty sample";
  if (sample.getDimension() != 1) throw InvalidArgumentException(HERE) << "Error: can build a Student distribution only from a sample of dimension 1, here dimension=" << sample.getDimension();
  const NumericalScalar mu(sample.computeMean()[0]);
  const NumericalScalar sigma(sample.computeStandardDeviationPerComponent()[0]);
  const NumericalScalar nu(2.0 + 2.0 / (sigma * sigma - 1.0));
  if (nu <= 2.0) throw InternalException(HERE) << "Error: can build a Student distribution only if nu > 2.0, here nu=" << nu;
  return Student(nu, mu).clone();
}

Student * StudentFactory::build() const
{
  return Student().clone();
}


END_NAMESPACE_OPENTURNS
