//                                               -*- C++ -*-
/**
 *  @file  t_NumericalMathFunction_timeseries.cxx
 *  @brief The test file of class NumericalMathFunction with timeseries
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2011-11-17 13:46:13 +0100 (Thu, 17 Nov 2011) $
 *  Id:      $Id: t_NumericalMathFunction_timeseries.cxx 2192 2011-11-17 12:46:13Z dutka $
 */
#include <iostream>
#include <sstream>
#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "NumericalMathFunction.hxx"

using namespace OT;
using namespace OT::Test;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {

    // Test basic functionnalities
    //checkClassWithClassName<ComputedNumericalMathEvaluationImplementation>();

    // Test some extra functionnalities
    //checkNameFeature<ComputedNumericalMathEvaluationImplementation>();


    /** Instance creation */
    NumericalMathFunction deviation("poutre");

    NumericalPoint inPoint1(4);
    inPoint1[0] = 210.e9;
    inPoint1[1] = 1000;
    inPoint1[2] = 1.4;
    inPoint1[3] = 2.e-6;

    NumericalPoint inPoint2(4);
    inPoint2[0] = 210.e9;
    inPoint2[1] = 1000;
    inPoint2[2] = 1.5;
    inPoint2[3] = 2.e-6;

    NumericalPoint inPoint3(4);
    inPoint3[0] = 210.e9;
    inPoint3[1] = 1000;
    inPoint3[2] = 1.6;
    inPoint3[3] = 2.e-6;

    TimeSeries inTimeSeries(3, deviation.getInputDimension());
    inTimeSeries.setValueAtIndex( 0, inPoint1 );
    inTimeSeries.setValueAtIndex( 1, inPoint2 );
    inTimeSeries.setValueAtIndex( 2, inPoint3 );

    TimeSeries outTimeSeries = deviation( inTimeSeries );

    fullprint << "deviation time series = " << outTimeSeries << std::endl;

  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }

  return ExitCode::Success;
}
