#! /usr/bin/env python

import sys

if len(sys.argv) != 2 : exit(1)

if sys.argv[1][0:7] != "system=" : exit(1)

system=sys.argv[1][7:]

from openturns import *
Log.Show(Log.ALL)
TESTPREAMBLE()

try :

  #Instance creation
  deviation = NumericalMathFunction("poutre_external_" + system)

  inPoint = NumericalPoint(4)
  inPoint[0] = 210.e9
  inPoint[1] = 1000
  inPoint[2] = 1.5
  inPoint[3] = 2.e-6

  outPoint = deviation( inPoint )

  print "deviation =", repr(outPoint)

except :
  import sys
  print "t_NumericalMathFunction_exec_external.py", sys.exc_type, sys.exc_value
