#! /usr/bin/env python

from openturns import *

TESTPREAMBLE()

try:
    data = NumericalSample(0, 1)

    # DEBUG ; ici attente de la TUI
    palette = Description()
    labels = Description()

    data.add(NumericalPoint(1, 5665855))
    labels.add("Candidate1")
    palette.add("blue")

    data.add(NumericalPoint(1, 4804713))
    labels.add("Candidate2")
    palette.add("white")

    data.add(NumericalPoint(1, 4610113))
    labels.add("Candidate3")
    palette.add("pink")

    data.add(NumericalPoint(1, 1949170))
    labels.add("Candidate4")
    palette.add("yellow")

    data.add(NumericalPoint(1, 1630045))
    labels.add("Candidate5")
    palette.add("red")

    data.add(NumericalPoint(1, 1518528))
    labels.add("Candidate6")
    palette.add("ivory")

    data.add(NumericalPoint(1, 1495724))
    labels.add("Candidate7")
    palette.add("green")

    data.add(NumericalPoint(1, 1210562))
    labels.add("Candidate8")
    palette.add("orange")

    data.add(NumericalPoint(1, 1204689))
    labels.add("Candidate9")
    palette.add("maroon")

    data.add(NumericalPoint(1, 1113484))
    labels.add("Candidate10")
    palette.add("violet")

    data.add(NumericalPoint(1, 3295588))
    labels.add("cumul candidates < 3.5% ")
    palette.add("purple")

    # Create an empty graph
    myGraph = Graph(
        "Presidentielle 2002 - 1er tour", "x1", "x2", True, "topright")

    # Create the first cloud
    myPie1 = Pie(data, labels, NumericalPoint(2), 1, palette)

    # Then, draw it
    myGraph.add(myPie1)
    myGraph.draw("Graph_Pie_OT", 640, 480)

   # Check that the correct files have been generated by computing their
   # checksum
    print "bitmap=", myGraph.getBitmap()
    print "postscript=", myGraph.getPostscript()

except:
    import sys
    print "t_Pie_std.py", sys.exc_type, sys.exc_value
