/* Nessus
 * Copyright (C) 1998,1999,2000 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2,
 * as published by the Free Software Foundation
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * In addition, as a special exception, Renaud Deraison
 * gives permission to link the code of this program with any
 * version of the OpenSSL library which is distributed under a
 * license identical to that listed in the included COPYING.OpenSSL
 * file, and distribute linked combinations including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * this file, you may extend this exception to your version of the
 * file, but you are not obligated to do so.  If you do not wish to
 * do so, delete this exception statement from your version.
 *
 */
 

#include <includes.h>

#ifdef USE_GTK 
#include "gtk-compat.h"
#include <gtk/gtk.h>

#include "context.h"

#include "nessus_plugin.h"
#include "nessus_i18n.h"
#include "globals.h"

static void
show_deps(foo, name)
  GtkWidget * foo;
  char * name;
{
  GtkWindow * window = GTK_WINDOW(arg_get_value(MainDialog, "WINDOW"));
  GtkWidget * dialog;
  GtkWidget * vbox;
  GtkWidget * w;
  struct arglist * deps;
  char * lbl = emalloc(strlen(name) + 255);
  int label_size = 1024;
  char * label;
  sprintf(lbl, _("Dependencies of Plugin '%s'"), name);

  dialog = gtk_dialog_new_with_buttons(lbl, window,
                                       GTK_DIALOG_DESTROY_WITH_PARENT,
                                       GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE,
                                       NULL);
  gtk_window_set_resizable(GTK_WINDOW(dialog), TRUE);
  gtk_widget_realize(dialog);

  /* The overall vbox */
  vbox = GTK_DIALOG(dialog)->vbox;

  /* The titel as label again */
  w = gtk_label_new(lbl);
  efree(&lbl);
  gtk_box_pack_start(GTK_BOX(vbox), w, TRUE, TRUE, 5);
  gtk_misc_set_alignment((GtkMisc *)w, 0, 1);
  gtk_widget_show(w);

  /* A horizontal separator */
  w = gtk_hseparator_new();
  gtk_box_pack_start(GTK_BOX(vbox), w, TRUE, TRUE, 5);
  gtk_widget_show(w);

  deps = arg_get_value(Context->dependencies, name);

  label = emalloc(label_size);

  /* In case we find no dependencies, create a hint on this */
  if (!deps || !deps->next)
  {
    strncpy(label, _("No dependencies found."), label_size);
    w = gtk_label_new(label);
    gtk_box_pack_start(GTK_BOX(vbox), w,   TRUE, TRUE, 2);
    gtk_misc_set_alignment((GtkMisc *)w, 0, 1);
    gtk_widget_show(w);
  }

  while(deps && deps->next)
  {
    struct nessus_plugin * p = nessus_plugin_get_by_name(Context->plugins, deps->name);

    if(p == NULL)
      p = nessus_plugin_get_by_name(Context->scanners, deps->name);

    if(p != NULL )
    {
      char * family = p->family;
      if(strlen(deps->name) + strlen(family) + 255 > label_size)
      {
        label_size *= 2;
        label = erealloc(label, label_size);
      }
      strncpy(label, deps->name, label_size);
      strncat(label, " (", label_size);
      strncat(label, family, label_size);
      strncat(label, _("), currently "), label_size);
      if (p->enabled != 0 )
        strncat(label, _("enabled"), label_size);
      else
        strncat(label, _("disabled"), label_size);
    }
    else
      strncpy(label, deps->name, label_size);
    w = gtk_label_new(label);
    gtk_box_pack_start(GTK_BOX(vbox), w,   TRUE, TRUE, 2);
    gtk_misc_set_alignment((GtkMisc *)w, 0, 1);
    gtk_widget_show(w);
    deps = deps->next;
  }

  efree(&label);

  /* execute and later remove the dialog */
  gtk_dialog_run(GTK_DIALOG(dialog));
  gtk_widget_destroy(dialog);
}

static void 
do_set_timeout(ctrls)
 struct arglist * ctrls;
{ 
 struct arglist * serv_prefs = arg_get_value(Context->prefs, "SERVER_PREFS");
 GtkWidget * w      = arg_get_value(ctrls, "ENTRY");
 char * to;
 int id;
 char * pref;
 int type;
 
 id  = (int)arg_get_value(ctrls, "ID");
 
 to = (char*)gtk_entry_get_text(GTK_ENTRY(w));
 pref = emalloc(40);
 
 sprintf(pref, "timeout.%d", id);
 if((type = arg_get_type(serv_prefs, pref)) >= 0)
 {
  char * old = arg_get_value(serv_prefs, pref);
  if(type == ARG_STRING)efree(&old);
  arg_set_type(serv_prefs, pref, ARG_STRING);
  arg_set_value(serv_prefs, pref, sizeof(int), estrdup(to));
 }
 else
  arg_add_value(serv_prefs, pref, ARG_STRING, sizeof(int), estrdup(to));
}



void
set_timeout_build_window(id, cur_to, def_to)
  int id;
  char* cur_to;
  int def_to;
{
  GtkWindow * window = GTK_WINDOW(arg_get_value(MainDialog, "WINDOW"));
  GtkWidget * dialog;
  GtkWidget * vbox;
  GtkWidget * hbox;
  GtkWidget * w;
  struct arglist * ctrls = emalloc(sizeof(*ctrls));

  dialog = gtk_dialog_new_with_buttons(_("Set plugin timeout..."), window,
                                       GTK_DIALOG_DESTROY_WITH_PARENT,
                                       GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                                       GTK_STOCK_OK, GTK_RESPONSE_OK, NULL);
  gtk_dialog_set_default_response(GTK_DIALOG(dialog), GTK_RESPONSE_CANCEL);
  gtk_window_set_resizable(GTK_WINDOW(dialog), TRUE);
  gtk_widget_realize(dialog);

  /* The overall vbox */
  vbox = GTK_DIALOG(dialog)->vbox;

  /* A hbox that contains the label and entry field */
  hbox = gtk_hbox_new(FALSE, 5);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 10);
  gtk_widget_show(hbox);

  /* The label for the entry field */
  w = gtk_label_new(_("Set plugin timeout:"));
  gtk_box_pack_start(GTK_BOX(hbox), w, TRUE, TRUE, 10);
  gtk_misc_set_alignment((GtkMisc *)w, 0, 1);
  gtk_widget_show(w);

  /* Then entry field for the timeout */
  w = gtk_entry_new();
  gtk_box_pack_start(GTK_BOX(hbox),w, TRUE, TRUE, 10);
  gtk_widget_show(w);
  if(!def_to)
    gtk_entry_set_text(GTK_ENTRY(w), cur_to);

  arg_add_value(ctrls, "WINDOW", ARG_PTR, -1, window);
  arg_add_value(ctrls, "ENTRY", ARG_PTR, -1, w);
  arg_add_value(ctrls, "ID", ARG_INT, sizeof(int), (void*)id);

  /* execute and later remove the dialog */
  switch (gtk_dialog_run(GTK_DIALOG(dialog)))
  {
    case GTK_RESPONSE_OK:
      do_set_timeout(ctrls);
      break;
  }
  gtk_widget_destroy(dialog);
}




static int
set_timeout(w, id)
 GtkWidget * w;
 int id;
{
 struct arglist * serv_prefs = arg_get_value(Context->prefs, "SERVER_PREFS");
 char * name = emalloc(40);
 int to_set = 1;
 char* timeout = NULL;
 
 sprintf(name, "timeout.%d", id);
 if(arg_get_type(serv_prefs,  name) == ARG_STRING)
  timeout = arg_get_value(serv_prefs, name);
 else
  to_set = 0;
    
    
 /*
  * Now, build a dialog
  */ 
  
 set_timeout_build_window(id, timeout, !to_set);
 return 0;
}





/*
 * plugin_info_window_setup 
 *
 * This function draws the window
 * which contains informations about a plugin
 */
void 
plugin_info_window_setup(res, pluginname)
 struct nessus_plugin * res;
 char * pluginname;
{
  GtkWindow * window = GTK_WINDOW(arg_get_value(MainDialog, "WINDOW"));
  GtkWidget * dialog;
  GtkWidget * vbox;
  GtkWidget * hbox;
  GtkWidget * label;
  GtkWidget * scrolledwindow;
  GtkWidget * textview;
  GtkWidget * button;
  GtkWidget * separator;

  char buf[4096];
  struct nessus_plugin * plugin;
  char * txt;

  plugin = nessus_plugin_get_by_name(res, pluginname);
  if( plugin == NULL )
  {
#ifdef DEBUG
    fprintf(stderr, _("Error ! Plugin selected not found ?!\n"));
#endif
    return;
  }

  dialog = gtk_dialog_new_with_buttons(pluginname, window,
                                       GTK_DIALOG_DESTROY_WITH_PARENT,
                                       GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE,
                                       NULL);
  gtk_window_set_resizable(GTK_WINDOW(dialog), TRUE);
  gtk_dialog_set_default_response(GTK_DIALOG(dialog), GTK_RESPONSE_CLOSE);
  gtk_window_set_default_size(GTK_WINDOW(dialog), 350, 450);
  gtk_widget_realize(dialog);

  /* The overall vbox */
  vbox = GTK_DIALOG(dialog)->vbox;

  /* The plugin name */
  label = gtk_label_new(pluginname);
  gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE,0);
  gtk_misc_set_alignment((GtkMisc *)label, 0, 1);
  gtk_widget_show(label);

  /* The copyright notice */
  label = gtk_label_new(plugin->copyright);
  gtk_box_pack_start(GTK_BOX(vbox), label, FALSE,FALSE,0);
  gtk_misc_set_alignment((GtkMisc *)label, 0, 1);
  gtk_widget_show(label);

  /* A separator */
  separator = gtk_hseparator_new();
  gtk_box_pack_start(GTK_BOX(vbox), separator, FALSE, FALSE,0);
  gtk_widget_show(separator);

  /* The Family */
  snprintf(buf, sizeof(buf), _("Family: %s"), plugin->family);
  label = gtk_label_new(buf);
  gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE,0);
  gtk_misc_set_alignment((GtkMisc *)label, 0, 1);
  gtk_widget_show(label);

  /* The Category */
  snprintf(buf, sizeof(buf), _("Category: %s"), plugin->category);
  label = gtk_label_new(buf);
  gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE,0);
  gtk_misc_set_alignment((GtkMisc *)label, 0, 1);
  gtk_widget_show(label);

  /* The Plugin ID */
  snprintf(buf, sizeof(buf), _("OpenVAS Plugin ID: %d"), plugin->id);
  label = gtk_label_new(buf);
  gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE,0);
  gtk_misc_set_alignment((GtkMisc *)label, 0, 1);
  gtk_widget_show(label);

  /* The CVE ID (in case the plugin provides one) */
  txt = plugin->cve;
  if( txt != NULL && txt[0] != '\0' )
  {
    snprintf(buf, sizeof(buf), _("CVE: %s"), txt);
    label = gtk_label_new(buf);
    gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE,0);
    gtk_misc_set_alignment((GtkMisc *)label, 0, 1);
    gtk_widget_show(label);
  }

  /* The Bugtraq ID (in case the plugin provides one) */
  txt = plugin->bid;
  if( txt != NULL  && txt[0] != '\0' )
  {
    snprintf(buf, sizeof(buf), _("Bugtraq ID: %s"), txt);
    label = gtk_label_new(buf);
    gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE,0);
    gtk_misc_set_alignment((GtkMisc *)label, 0, 1);
    gtk_widget_show(label);
  }

  /* The other cross references (in case the plugin provides one) */
  txt = plugin->xrefs;
  if( txt != NULL  && txt[0] != '\0' )
  {
    snprintf(buf, sizeof(buf), _("Other references: %s"), txt);
    label = gtk_label_new(buf);
    gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE,0);
    gtk_misc_set_alignment((GtkMisc *)label, 0, 1);
    gtk_widget_show(label);
  }

  /* The Version */
  label = gtk_label_new( plugin->version );
  gtk_box_pack_start(GTK_BOX(vbox), label, FALSE,FALSE,0);
  gtk_misc_set_alignment((GtkMisc *)label, 0, 1);
  gtk_widget_show(label);

  /* A separator */
  separator = gtk_hseparator_new();
  gtk_box_pack_start(GTK_BOX(vbox), separator, FALSE, FALSE,0);
  gtk_widget_show(separator);

  /* The titel for the scrolled text */
  label = gtk_label_new(_("What is shown if the attack is successful:"));
  gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE,0);
  gtk_misc_set_alignment((GtkMisc *)label, 0, 1);
  gtk_widget_show(label);

  /* The scrolled window */
  scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
  gtk_box_pack_start(GTK_BOX(vbox), scrolledwindow, TRUE, TRUE, 5);
  gtk_widget_show(scrolledwindow);

  /* The textview with the plugin description */
  textview = gtk_text_view_new();
  gtk_container_add(GTK_CONTAINER(scrolledwindow), textview);
  gtk_text_view_set_editable(GTK_TEXT_VIEW(textview), FALSE);
  gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(textview), GTK_WRAP_WORD);
  {
   char * s = nessus_plugin_get_description(plugin);
  if ( s != NULL )
    gtk_text_buffer_set_text(gtk_text_view_get_buffer(GTK_TEXT_VIEW(textview)),s, -1);
  }
  gtk_widget_show (textview);

  /* A hbox for the buttons */
  hbox = gtk_hbox_new(FALSE,10);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE,FALSE,10);
  gtk_widget_show(hbox);

  /* The button for setting the plugin timeout */
  button = gtk_button_new_with_label(_("Set plugin timeout..."));
  g_signal_connect(GTK_OBJECT(button), "clicked",GTK_SIGNAL_FUNC(set_timeout),
                   (void*)plugin->id);
  gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 5);
  gtk_widget_show(button);

  /* The button for displaying the dependencies */
  button = gtk_button_new_with_label(_("Show dependencies"));
  g_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(show_deps),
                   plugin->name);
  gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 5);
  gtk_widget_show(button);
  if(!arg_get_value(Context->dependencies, pluginname))
    gtk_widget_set_sensitive(button,FALSE);


  /* execute and later remove the dialog */
  gtk_dialog_run(GTK_DIALOG(dialog));
  gtk_widget_destroy(dialog);
}
#endif
