# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0008 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63113);
 script_cve_id("CVE-2008-3834");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0008";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory RHSA-2009:0008.

D-Bus is a system for sending messages between applications. It is used for
the system-wide message bus service and as a per-user-login-session
messaging facility.

A denial-of-service flaw was discovered in the system for sending messages
between applications. A local user could send a message with a malformed
signature to the bus causing the bus (and, consequently, any process using
libdbus to receive messages) to abort. (CVE-2008-3834)

All users are advised to upgrade to these updated dbus packages, which
contain backported patch which resolve this issue. For the update to take
effect, all running instances of dbus-daemon and all running applications
using libdbus library must be restarted, or the system rebooted.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0008.html
http://www.redhat.com/security/updates/classification/#moderate

Risk factor : Medium";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0008";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"dbus", rpm:"dbus~1.0.0~7.el5_2.1", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-debuginfo", rpm:"dbus-debuginfo~1.0.0~7.el5_2.1", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-x11", rpm:"dbus-x11~1.0.0~7.el5_2.1", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-devel", rpm:"dbus-devel~1.0.0~7.el5_2.1", rls:"RHENT_5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
