# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory RHSA-2009:0392 ()
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63644);
 script_cve_id("CVE-2006-2426", "CVE-2009-1093", "CVE-2009-1094", "CVE-2009-1095", "CVE-2009-1096", "CVE-2009-1097", "CVE-2009-1098", "CVE-2009-1099", "CVE-2009-1100", "CVE-2009-1101", "CVE-2009-1102", "CVE-2009-1103", "CVE-2009-1104", "CVE-2009-1105", "CVE-2009-1106", "CVE-2009-1107");
 script_version ("$");
 name["english"] = "RedHat Security Advisory RHSA-2009:0392";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory RHSA-2009:0392.

The Sun 1.6.0 Java release includes the Sun Java 6 Runtime Environment and
the Sun Java 6 Software Development Kit.

This update fixes several vulnerabilities in the Sun Java 6 Runtime
Environment and the Sun Java 6 Software Development Kit. These
vulnerabilities are summarized on the Advance notification of Security
Updates for Java SE page from Sun Microsystems, listed in the References
section. (CVE-2006-2426, CVE-2009-1093, CVE-2009-1094, CVE-2009-1095,
CVE-2009-1096, CVE-2009-1097, CVE-2009-1098, CVE-2009-1099, CVE-2009-1100,
CVE-2009-1101, CVE-2009-1102, CVE-2009-1103, CVE-2009-1104, CVE-2009-1105,
CVE-2009-1106, CVE-2009-1107)

Users of java-1.6.0-sun should upgrade to these updated packages, which
correct these issues. All running instances of Sun Java must be restarted
for the update to take effect.

Solution:
Please note that this update is available via
Red Hat Network.  To use Red Hat Network, launch the Red
Hat Update Agent with the following command: up2date

http://rhn.redhat.com/errata/RHSA-2009-0392.html
http://www.redhat.com/security/updates/classification/#critical
http://blogs.sun.com/security/entry/advance_notification_of_security_updates4

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Redhat Security Advisory RHSA-2009:0392";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"java-1.6.0-sun", rpm:"java-1.6.0-sun~1.6.0.13~1jpp.1.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.6.0-sun-demo", rpm:"java-1.6.0-sun-demo~1.6.0.13~1jpp.1.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.6.0-sun-devel", rpm:"java-1.6.0-sun-devel~1.6.0.13~1jpp.1.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.6.0-sun-jdbc", rpm:"java-1.6.0-sun-jdbc~1.6.0.13~1jpp.1.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.6.0-sun-plugin", rpm:"java-1.6.0-sun-plugin~1.6.0.13~1jpp.1.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.6.0-sun-src", rpm:"java-1.6.0-sun-src~1.6.0.13~1jpp.1.el4", rls:"RHENT_4")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.6.0-sun", rpm:"java-1.6.0-sun~1.6.0.13~1jpp.1.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.6.0-sun-demo", rpm:"java-1.6.0-sun-demo~1.6.0.13~1jpp.1.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.6.0-sun-devel", rpm:"java-1.6.0-sun-devel~1.6.0.13~1jpp.1.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.6.0-sun-jdbc", rpm:"java-1.6.0-sun-jdbc~1.6.0.13~1jpp.1.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.6.0-sun-plugin", rpm:"java-1.6.0-sun-plugin~1.6.0.13~1jpp.1.el5", rls:"RHENT_5")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.6.0-sun-src", rpm:"java-1.6.0-sun-src~1.6.0.13~1jpp.1.el5", rls:"RHENT_5")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
