# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1145-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57262);
 script_cve_id("CVE-2005-4745", "CVE-2005-4746", "CVE-2006-4746");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1145-1 (freeradius)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to freeradius
announced via advisory DSA 1145-1.

Several remote vulnerabilities have been discovered in freeradius, a
high-performance RADIUS server, which may lead to SQL injection or denial
of service. The Common Vulnerabilities and Exposures project identifies
the following problems:

CVE-2005-4745

An SQL injection vulnerability has been discovered in the
rlm_sqlcounter module.

CVE-2006-4746

Multiple buffer overflows have been discovered, allowing denial of
service.

For the stable distribution (sarge) these problems have been fixed in
version 1.0.2-4sarge3.

For the unstable distribution (sid) these problems have been fixed in
version 1.0.5-1.

We recommend that you upgrade your freeradius packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201145-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1145-1 (freeradius)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"freeradius-dialupadmin", ver:"1.0.2-4sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"freeradius", ver:"1.0.2-4sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"freeradius-iodbc", ver:"1.0.2-4sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"freeradius-krb5", ver:"1.0.2-4sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"freeradius-ldap", ver:"1.0.2-4sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"freeradius-mysql", ver:"1.0.2-4sarge3", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
