# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1197-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57538);
 script_cve_id("CVE-2006-4980");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1197-1 (python2.4)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to python2.4
announced via advisory DSA 1197-1.

Benjamin C. Wiley Sittler discovered that the repr() of the Python
interpreter allocates insufficient memory when parsing UCS-4 Unicode
strings, which might lead to execution of arbitrary code through
a buffer overflow.

For the stable distribution (sarge) this problem has been fixed in
version 2.4.1-2sarge1. Due to build problems this update lacks fixed
packages for the m68k architecture. Once they are sorted out, binaries
for m68k will be released.

For the unstable distribution (sid) this problem has been fixed in
version 2.4.4-1.

We recommend that you upgrade your Python 2.4 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201197-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1197-1 (python2.4)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"idle-python2.4", ver:"2.4.1-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4-doc", ver:"2.4.1-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4-examples", ver:"2.4.1-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4", ver:"2.4.1-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4-dbg", ver:"2.4.1-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4-dev", ver:"2.4.1-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4-gdbm", ver:"2.4.1-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4-tk", ver:"2.4.1-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
