# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 152-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53412);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 152-1 (l2tpd)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to l2tpd
announced via advisory DSA 152-1.

Current versions of l2tpd, a layer 2 tunneling client/server program,
forgot to initialize the random generator which made it vulnerable
since all generated random number were 100% guessable.  When dealing
with the size of the value in an attribute value pair, too many bytes
were able to be copied, which could lead into the vendor field being
overwritten.

These problems have been fixed in version 0.67-1.1 for the current
stable distribution (woody) and in version 0.68-1 for the unstable
distribution (sid).  The old stable distribution (potato) is not
affected, since it doesn't contain the l2tpd package.

We recommend that you upgrade your l2tpd packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20152-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 152-1 (l2tpd)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"l2tpd", ver:"0.67-1.1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
