# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1801-1 (ntp)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64032);
 script_cve_id("CVE-2009-0159", "CVE-2009-1252");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1801-1 (ntp)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to ntp
announced via advisory DSA 1801-1.

Several remote vulnerabilities have been discovered in NTP, the Network
Time Protocol reference implementation. The Common Vulnerabilities and
Exposures project identifies the following problems:

CVE-2009-0159

A buffer overflow in ntpq allow a remote NTP server to create a
denial of service attack or to execute arbitrary code via a crafted
response.

CVE-2009-1252

A buffer overflow in ntpd allows a remote attacker to create a
denial of service attack or to execute arbitrary code when the
autokey functionality is enabled.

For the old stable distribution (etch), these problems have been fixed in
version 4.2.2.p4+dfsg-2etch3.

For the stable distribution (lenny), these problems have been fixed in
version 4.2.4p4+dfsg-8lenny2.

The unstable distribution (sid) will be fixed soon.

We recommend that you upgrade your ntp package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201801-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1801-1 (ntp)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ntp-refclock", ver:"4.2.2.p4+dfsg-2etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntp-doc", ver:"4.2.2.p4+dfsg-2etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntp-simple", ver:"4.2.2.p4+dfsg-2etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntpdate", ver:"4.2.2.p4+dfsg-2etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntp", ver:"4.2.2.p4+dfsg-2etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntp-doc", ver:"4.2.4p4+dfsg-8lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntpdate", ver:"4.2.4p4+dfsg-8lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntp", ver:"4.2.4p4+dfsg-8lenny2", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
