# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 274-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53341);
 script_cve_id("CVE-2003-0167");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 274-1 (mutt)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to mutt
announced via advisory DSA 274-1.

Byrial Jensen discovered a couple of off-by-one buffer overflow in the
IMAP code of Mutt, a text-oriented mail reader supporting IMAP, MIME,
GPG, PGP and threading.  This problem could potentially allow a remote
malicious IMAP server to cause a denial of service (crash) and
possibly execute arbitrary code via a specially crafted mail folder.

For the stable distribution (woody) this problem has been fixed in
version 1.3.28-2.2.

The old stable distribution (potato) is also affected by this problem
and an update will follow.

For the unstable distribution (sid) this problem has been fixed in
version 1.4.0 and above.

We recommend that you upgrade your mutt package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20274-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 274-1 (mutt)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mutt", ver:"1.3.28-2.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mutt-utf8", ver:"1.3.28-2.2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
