# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 316-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53605);
 script_cve_id("CVE-2003-0358", "CVE-2003-0359");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 316-1 (nethack)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to nethack
announced via advisory DSA 316-1.

The nethack package is vulnerable to a buffer overflow exploited via a
long '-s' command line option.  This vulnerability could be used by an
attacker to gain gid 'games' on a system where nethack is installed.

Additionally, some setgid binaries in the nethack package have
incorrect permissions, which could allow a user who gains gid 'games'
to replace these binaries, potentially causing other users to execute
malicious code when they run nethack.

For the stable distribution (woody) these problems have been fixed in
version 3.4.0-3.0woody3.

For the old stable distribution (potato) problem xxx has been fixed in
version 3.3.0-7potato1.

For the unstable distribution (sid) these problems are fixed in
version 3.4.1-1.

We recommend that you update your nethack package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20316-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 316-1 (nethack)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"nethack", ver:"3.3.0-7potato1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nethack", ver:"3.4.0-3.0woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nethack-common", ver:"3.4.0-3.0woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nethack-gnome", ver:"3.4.0-3.0woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nethack-qt", ver:"3.4.0-3.0woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nethack-x11", ver:"3.4.0-3.0woody3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
