# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 948-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56190);
 script_bugtraq_id(16325);
 script_cve_id("CVE-2006-0019");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 948-1 (kdelibs)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to kdelibs
announced via advisory DSA 948-1.

Maksim Orlovich discovered that the kjs Javascript interpreter, used
in the Konqueror web browser and in other parts of KDE, performs
insufficient bounds checking when parsing UTF-8 encoded Uniform Resource
Identifiers, which may lead to a heap based buffer overflow and the
execution of arbitrary code.

The old stable distribution (woody) is not affected by this problem.

For the stable distribution (sarge) this problem has been fixed in
version 3.3.2-6.4

For the unstable distribution (sid) this problem will be fixed soon.

We recommend that you upgrade your kdelibs package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20948-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 948-1 (kdelibs)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kdelibs-data", ver:"3.3.2-6.4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs4-doc", ver:"3.3.2-6.4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs", ver:"3.3.2-6.4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs-bin", ver:"3.3.2-6.4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs4", ver:"3.3.2-6.4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs4-dev", ver:"3.3.2-6.4", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
