# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-2852 (krb5)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63778);
 script_cve_id("CVE-2009-0844", "CVE-2009-0845", "CVE-2009-0846", "CVE-2009-0847");
 script_version ("$");
 name["english"] = "Fedora Core 10 FEDORA-2009-2852 (krb5)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to krb5
announced via advisory FEDORA-2009-2852.

Update Information:

This update incorporates patches to fix potential read overflow and NULL pointer
dereferences in the implementation of the SPNEGO GSSAPI mechanism
(CVE-2009-0844, CVE-2009-0845), attempts to free an uninitialized pointer during
protocol parsing (CVE-2009-0846), and a bug in length validation during protocol
parsing (CVE-2009-0847).

ChangeLog:

* Tue Apr  7 2009 Nalin Dahyabhai  1.6.3-18
- add patches for read overflow and null pointer dereference in the
implementation of the SPNEGO mechanism (CVE-2009-0844, CVE-2009-0845)
- add patch for attempt to free uninitialized pointer in libkrb5
(CVE-2009-0846)
- add patch to fix length validation bug in libkrb5 (CVE-2009-0847)
* Tue Mar 17 2009 Nalin Dahyabhai  1.6.3-17
- libgssapi_krb5: backport fix for some errors which can occur when
we fail to set up the server half of a context (CVE-2009-0845)

References:

[ 1 ] Bug #490634 - CVE-2009-0845 krb5: Null pointer dereference in GSSAPI SPNEGO security mechanism
https://bugzilla.redhat.com/show_bug.cgi?id=490634
[ 2 ] Bug #491033 - CVE-2009-0844 krb5: buffer over-read in SPNEGO GSS-API mechanism (MITKRB5-SA-2009-001)
https://bugzilla.redhat.com/show_bug.cgi?id=491033
[ 3 ] Bug #491036 - CVE-2009-0846 krb5: ASN.1 decoder can free uninitialized pointer when decoding an invalid encoding (MITKRB5-SA-2009-002)
https://bugzilla.redhat.com/show_bug.cgi?id=491036
[ 4 ] Bug #491034 - CVE-2009-0847 krb5: incorrect length check inside ASN.1 decoder (MITKRB5-SA-2009-001)
https://bugzilla.redhat.com/show_bug.cgi?id=491034

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update krb5' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-2852

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Fedora Core 10 FEDORA-2009-2852 (krb5)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"krb5-devel", rpm:"krb5-devel~1.6.3~18.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"krb5-libs", rpm:"krb5-libs~1.6.3~18.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"krb5-pkinit-openssl", rpm:"krb5-pkinit-openssl~1.6.3~18.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"krb5-server", rpm:"krb5-server~1.6.3~18.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"krb5-server-ldap", rpm:"krb5-server-ldap~1.6.3~18.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"krb5-workstation", rpm:"krb5-workstation~1.6.3~18.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"krb5-workstation-clients", rpm:"krb5-workstation-clients~1.6.3~18.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"krb5-workstation-servers", rpm:"krb5-workstation-servers~1.6.3~18.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"krb5-debuginfo", rpm:"krb5-debuginfo~1.6.3~18.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
