# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-3709 (ghostscript)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63835);
 script_cve_id("CVE-2009-0792", "CVE-2009-0196", "CVE-2008-6679", "CVE-2009-0583", "CVE-2009-0584");
 script_version ("$");
 name["english"] = "Fedora Core 10 FEDORA-2009-3709 (ghostscript)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to ghostscript
announced via advisory FEDORA-2009-3709.

Update Information:

This update fixes several security flaws: CVE-2009-0792 (multiple integer
overflows and missing upper-bounds checks in icclib), CVE-2009-0196 (missing
boundary check in jbig2dec library), and CVE-2008-6679 (buffer overflow in
pdfwrite device).

ChangeLog:

* Wed Apr 15 2009 Tim Waugh  8.63-6
- Applied patch to fix CVE-2009-0792 (bug #491853).
- Applied patch to fix CVE-2009-0196 (bug #493379).
- Applied patch to fix CVE-2008-6679 (bug #493445).
* Fri Mar 20 2009 Tim Waugh  8.63-5
- Applied patch to fix CVE-2009-0583 (bug #487742) and CVE-2009-0584
(bug #487744).

References:

[ 1 ] Bug #493445 - CVE-2008-6679 ghostscript: Buffer overflow in BaseFont writer module for pdfwrite defice
https://bugzilla.redhat.com/show_bug.cgi?id=493445
[ 2 ] Bug #493379 - CVE-2009-0196 ghostscript: Missing boundary check in Ghostscript's jbig2dec library
https://bugzilla.redhat.com/show_bug.cgi?id=493379
[ 3 ] Bug #491853 - CVE-2009-0792 ghostscript, argyllcms: Incomplete fix for CVE-2009-0583
https://bugzilla.redhat.com/show_bug.cgi?id=491853

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update ghostscript' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-3709

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Fedora Core 10 FEDORA-2009-3709 (ghostscript)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"ghostscript", rpm:"ghostscript~8.63~6.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-devel", rpm:"ghostscript-devel~8.63~6.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-doc", rpm:"ghostscript-doc~8.63~6.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-gtk", rpm:"ghostscript-gtk~8.63~6.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-debuginfo", rpm:"ghostscript-debuginfo~8.63~6.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
