#
#VID 02eedd3c-c6b5-11dc-93b6-000e35248ad7
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(60230);
 script_cve_id("CVE-2008-0225");
 script_version ("$");
 name["english"] = "FreeBSD Ports: libxine";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: libxine

CVE-2008-0225
Heap-based buffer overflow in the rmff_dump_cont function in
input/libreal/rmff.c in xine-lib 1.1.9 and earlier allows remote
attackers to execute arbitrary code via the SDP Abstract attribute in
an RTSP session, related to the rmff_dump_header function and related
to disregarding the max field.  NOTE: some of these details are
obtained from third party information.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://aluigi.altervista.org/adv/xinermffhof-adv.txt
http://secunia.com/advisories/28384
http://www.vuxml.org/freebsd/02eedd3c-c6b5-11dc-93b6-000e35248ad7.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: libxine";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"libxine");
if(!isnull(bver) && revcomp(a:bver, b:"1.1.9.1")<0) {
    security_note(0, data:"Package libxine version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
