#
#VID 22c6b826-cee0-11da-8578-00123ffe8333
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56575);
 script_bugtraq_id(17484);
 script_cve_id("CVE-2006-1711");
 script_version ("$");
 name["english"] = "FreeBSD Ports: plone";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: plone

CVE-2006-1711
Plone 2.0.5, 2.1.2, and 2.5-beta1 does not restrict access to the (1)
changeMemberPortrait, (2) deletePersonalPortrait, and (3)
testCurrentPassword methods, which allows remote attackers to modify
portraits.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://dev.plone.org/plone/ticket/5432
http://www.debian.org/security/2006/dsa-1032
http://secunia.com/advisories/19633/
http://www.vuxml.org/freebsd/22c6b826-cee0-11da-8578-00123ffe8333.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: plone";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"plone");
if(!isnull(bver) && revcomp(a:bver, b:"2.1.2_1")<0) {
    security_note(0, data:"Package plone version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
