#
#VID 13d6d997-f455-11dd-8516-001b77d09812
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 13d6d997-f455-11dd-8516-001b77d09812
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63362);
 script_cve_id("CVE-2009-0034");
 script_bugtraq_id(33517);
 script_version ("$");
 name["english"] = "FreeBSD Ports: sudo";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: sudo

CVE-2009-0034
parse.c in sudo 1.6.9p17 through 1.6.9p19 does not properly interpret
a system group (aka %group) in the sudoers file during authorization
decisions for a user who belongs to that group, which allows local
users to leverage an applicable sudoers file and gain root privileges
via a sudo command.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.gratisoft.us/pipermail/sudo-announce/2009-February/000085.html
http://www.vuxml.org/freebsd/13d6d997-f455-11dd-8516-001b77d09812.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: sudo";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"sudo");
if(!isnull(bver) && revcomp(a:bver, b:"1.6.9")>=0 && revcomp(a:bver, b:"1.6.9.20")<0) {
    security_note(0, data:"Package sudo version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
