###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for python-docs CESA-2007:1076 centos3 x86_64
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880314);
  script_version("$Revision: 1.0 $");
  script_xref(name: "CESA", value: "2007:1076");
  script_cve_id("CVE-2006-7228", "CVE-2007-2052", "CVE-2007-4965");
  script_name(english: "CentOS Update for python-docs CESA-2007:1076 centos3 x86_64");
  desc["english"] = "

  Vulnerability Insight:
  Python is an interpreted, interactive, object-oriented programming
  language.
  
  An integer overflow flaw was discovered in the way Python's pcre module
  handled certain regular expressions. If a Python application used the pcre
  module to compile and execute untrusted regular expressions, it may be
  possible to cause the application to crash, or allow arbitrary code
  execution with the privileges of the Python interpreter. (CVE-2006-7228)
  
  A flaw was discovered in the strxfrm() function of Python's locale module.
  Strings generated by this function were not properly NULL-terminated. This
  may possibly cause disclosure of data stored in the memory of a Python
  application using this function. (CVE-2007-2052)
  
  Multiple integer overflow flaws were discovered in Python's imageop module.
  If an application written in Python used the imageop module to process
  untrusted images, it could cause the application to crash, enter an
  infinite loop, or possibly execute arbitrary code with the privileges of
  the Python interpreter. (CVE-2007-4965)
  
  Users of Python are advised to upgrade to these updated packages, which
  contain backported patches to resolve these issues.


  Affected Software/OS:
  python-docs on CentOS 3

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2007-December/014497.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of python-docs");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CENTOS3")
{

  if(isrpmvuln(pkg:"python-docs", rpm:"python-docs~2.2.3~6.8", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python", rpm:"python~2.2.3~6.8", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-devel", rpm:"python-devel~2.2.3~6.8", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-tools", rpm:"python-tools~2.2.3~6.8", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tkinter", rpm:"tkinter~2.2.3~6.8", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}