###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for thunderbird CESA-2008:0209 centos4 i386
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880088);
  script_version("$Revision: 1.0 $");
  script_xref(name: "CESA", value: "2008:0209");
  script_cve_id("CVE-2008-1233", "CVE-2008-1234", "CVE-2008-1235", "CVE-2008-1236", "CVE-2008-1237", "CVE-2008-1238", "CVE-2008-1241");
  script_name(english: "CentOS Update for thunderbird CESA-2008:0209 centos4 i386");
  desc["english"] = "

  Vulnerability Insight:
  Mozilla Thunderbird is a standalone mail and newsgroup client.
  
  Several flaws were found in the processing of some malformed HTML mail
  content. An HTML mail message containing such malicious content could cause
  Thunderbird to crash or, potentially, execute arbitrary code as the user
  running Thunderbird. (CVE-2008-1233, CVE-2008-1235, CVE-2008-1236,
  CVE-2008-1237)
  
  Several flaws were found in the display of malformed web content. An HTML
  mail message containing specially-crafted content could, potentially, trick
  a user into surrendering sensitive information. (CVE-2008-1234,
  CVE-2008-1238, CVE-2008-1241)
  
  Note: JavaScript support is disabled by default in Thunderbird; the above
  issues are not exploitable unless JavaScript is enabled.
  
  All Thunderbird users should upgrade to these updated packages, which
  contain backported patches to resolve these issues.


  Affected Software/OS:
  thunderbird on CentOS 4

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2008-April/014807.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of thunderbird");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CENTOS4")
{

  if(isrpmvuln(pkg:"thunderbird", rpm:"thunderbird~1.5.0.12~10.el4.centos", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}