###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for libxslt CESA-2008:0287 centos3 i386
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880193);
  script_version("$Revision: 1.0 $");
  script_xref(name: "CESA", value: "2008:0287");
  script_cve_id("CVE-2008-1767");
  script_name(english: "CentOS Update for libxslt CESA-2008:0287 centos3 i386");
  desc["english"] = "

  Vulnerability Insight:
  libxslt is a C library, based on libxml, for parsing of XML files into
  other textual formats (eg HTML, plain text and other XML representations of
  the underlying data). It uses the standard XSLT stylesheet transformation
  mechanism and, being written in plain ANSI C, is designed to be simple to
  incorporate into other applications
  
  Anthony de Almeida Lopes reported the libxslt library did not properly
  process long &quot;transformation match&quot; conditions in the XSL stylesheet files.
  An attacker could create a malicious XSL file that would cause a crash, or,
  possibly, execute and arbitrary code with the privileges of the application
  using libxslt library to perform XSL transformations. (CVE-2008-1767)
  
  All users are advised to upgrade to these updated packages, which contain a
  backported patch to resolve this issue.


  Affected Software/OS:
  libxslt on CentOS 3

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2008-May/014920.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of libxslt");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CENTOS3")
{

  if(isrpmvuln(pkg:"libxslt", rpm:"libxslt~1.0.33~6", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxslt-devel", rpm:"libxslt-devel~1.0.33~6", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxslt-python", rpm:"libxslt-python~1.0.33~6", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}