###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for autofs RHSA-2007:1128-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870190);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2007:1128-01");
  script_cve_id("CVE-2007-5964");
  script_name(english: "RedHat Update for autofs RHSA-2007:1128-01");
  desc["english"] = "

  Vulnerability Insight:
  The autofs utility controls the operation of the automount daemon, which
  automatically mounts and unmounts file systems after a period of
  inactivity. 
  
  There was a security issue with the default installed configuration of
  autofs version 5 whereby the entry for the &quot;hosts&quot; map did not specify the
  &quot;nosuid&quot; mount option.  A local user with control of a remote nfs server
  could create a setuid root executable within an exported filesystem on the
  remote nfs server that, if mounted using the default hosts map, would allow
  the user to gain root privileges. (CVE-2007-5964) 
  
  Due to the fact that autofs always mounted hosts map entries suid by
  default, autofs has now been altered to always use the &quot;nosuid&quot; option when
  mounting from the default hosts map. The &quot;suid&quot; option must be explicitly
  given in the master map entry to revert to the old behavior. This change
  affects only the hosts map which corresponds to the /net entry in the
  default configuration.
  
  Users are advised to upgrade to these updated autofs packages, which
  resolve this issue.
  
  Red Hat would like to thank Josh Lange for reporting this issue.


  Affected Software/OS:
  autofs on Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2007-December/msg00009.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of autofs");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"autofs", rpm:"autofs~5.0.1~0.rc2.55.el5.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"autofs-debuginfo", rpm:"autofs-debuginfo~5.0.1~0.rc2.55.el5.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}