###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for kernel RHSA-2008:0089-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870168);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0089-01");
  script_cve_id("CVE-2007-3104", "CVE-2007-5904", "CVE-2007-6206", "CVE-2007-6416", "CVE-2008-0001");
  script_name(english: "RedHat Update for kernel RHSA-2008:0089-01");
  desc["english"] = "

  Vulnerability Insight:
  The kernel packages contain the Linux kernel, the core of any Linux
  operating system.
  
  These new kernel packages fix the following security issues:
  
  A flaw was found in the virtual filesystem (VFS). An unprivileged local
  user could truncate directories to which they had write permission; this
  could render the contents of the directory inaccessible. (CVE-2008-0001,
  Important)
  
  A flaw was found in the Xen PAL emulation on Intel 64 platforms. A guest
  Hardware-assisted virtual machine (HVM) could read the arbitrary physical
  memory of the host system, which could make information available to
  unauthorized users. (CVE-2007-6416, Important)
  
  A flaw was found in the way core dump files were created. If a local user
  can get a root-owned process to dump a core file into a directory, which
  the user has write access to, they could gain read access to that core
  file, potentially containing sensitive information. (CVE-2007-6206, Moderate)
  
  A buffer overflow flaw was found in the CIFS virtual file system. A
  remote,authenticated user could issue a request that could lead to a denial
  of service. (CVE-2007-5904, Moderate)
  
  A flaw was found in the &quot;sysfs_readdir&quot; function. A local user could create
  a race condition which would cause a denial of service (kernel oops).
  (CVE-2007-3104, Moderate)
  
  As well, these updated packages fix the following bugs:
  
  * running the &quot;strace -f&quot; command caused strace to hang, without displaying
  information about child processes.
  
  * unmounting an unresponsive, interruptable NFS mount, for example, one
  mounted with the &quot;intr&quot; option, may have caused a system crash.
  
  * a bug in the s2io.ko driver prevented VLAN devices from being added.
  Attempting to add a device to a VLAN, for example, running the &quot;vconfig
  add [device-name] [vlan-id]&quot; command caused vconfig to fail.
  
  * tux used an incorrect open flag bit. This caused problems when building
  packages in a chroot environment, such as mock, which is used by the koji
  build system.
  
  Red Hat Enterprise Linux 5 users are advised to upgrade to these updated
  packages, which contain backported patches to resolve these issues.


  Affected Software/OS:
  kernel on Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-January/msg00017.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of kernel");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.18~53.1.6.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-PAE", rpm:"kernel-PAE~2.6.18~53.1.6.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-PAE-debuginfo", rpm:"kernel-PAE-debuginfo~2.6.18~53.1.6.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-PAE-devel", rpm:"kernel-PAE-devel~2.6.18~53.1.6.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.18~53.1.6.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debug-debuginfo", rpm:"kernel-debug-debuginfo~2.6.18~53.1.6.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debug-devel", rpm:"kernel-debug-devel~2.6.18~53.1.6.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debuginfo", rpm:"kernel-debuginfo~2.6.18~53.1.6.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debuginfo-common", rpm:"kernel-debuginfo-common~2.6.18~53.1.6.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-devel", rpm:"kernel-devel~2.6.18~53.1.6.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-headers", rpm:"kernel-headers~2.6.18~53.1.6.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen", rpm:"kernel-xen~2.6.18~53.1.6.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen-debuginfo", rpm:"kernel-xen-debuginfo~2.6.18~53.1.6.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen-devel", rpm:"kernel-xen-devel~2.6.18~53.1.6.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.6.18~53.1.6.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}