###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for ImageMagick RHSA-2008:0165-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870041);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0165-01");
  script_cve_id("CVE-2007-1797", "CVE-2007-4985", "CVE-2007-4986", "CVE-2008-1097");
  script_name(english: "RedHat Update for ImageMagick RHSA-2008:0165-01");
  desc["english"] = "

  Vulnerability Insight:
  ImageMagick is an image display and manipulation tool for the X Window
  System that can read and write multiple image formats.
  
  Several heap-based buffer overflow flaws were found in ImageMagick. If a
  victim opened a specially-crafted DCM or XWD file, an attacker could
  potentially execute arbitrary code on the victim's machine. (CVE-2007-1797) 
  
  Several denial of service flaws were found in ImageMagick's parsing of XCF
  and DCM files. Attempting to process a specially crafted input file in
  these formats could cause ImageMagick to enter an infinite loop.
  (CVE-2007-4985) 
  
  Several integer overflow flaws were found in ImageMagick. If a victim
  opened a specially-crafted DCM, DIB, XBM, XCF or XWD file, an attacker
  could potentially execute arbitrary code with the privileges of the user
  running ImageMagick. (CVE-2007-4986)
  
  A heap-based buffer overflow flaw was found in ImageMagick's processing of
  certain malformed PCX images. If a victim opened a specially-crafted PCX
  file, an attacker could possibly execute arbitrary code with the privileges
  of the user running ImageMagick.. (CVE-2008-1097)
  
  All users of ImageMagick should upgrade to these updated packages, which
  contain backported patches to correct these issues.


  Affected Software/OS:
  ImageMagick on Red Hat Enterprise Linux AS (Advanced Server) version 2.1,
  Red Hat Enterprise Linux ES version 2.1,
  Red Hat Enterprise Linux WS version 2.1

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-April/msg00014.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of ImageMagick");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_2.1")
{

  if(isrpmvuln(pkg:"ImageMagick", rpm:"ImageMagick~5.3.8~21", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ImageMagick-c++", rpm:"ImageMagick-c++~5.3.8~21", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ImageMagick-c++-devel", rpm:"ImageMagick-c++-devel~5.3.8~21", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ImageMagick-devel", rpm:"ImageMagick-devel~5.3.8~21", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ImageMagick-perl", rpm:"ImageMagick-perl~5.3.8~21", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}