###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for squid RHSA-2008:0214-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870019);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0214-01");
  script_cve_id("CVE-2008-1612", "CVE-2007-6239");
  script_name(english: "RedHat Update for squid RHSA-2008:0214-01");
  desc["english"] = "

  Vulnerability Insight:
  Squid is a high-performance proxy caching server for Web clients,
  supporting FTP, gopher, and HTTP data objects.
  
  A flaw was found in the way squid manipulated HTTP headers for cached
  objects stored in system memory. An attacker could use this flaw to cause a
  squid child process to exit. This interrupted existing connections and made
  proxy services unavailable. Note: the parent squid process started a new
  child process, so this attack only resulted in a temporary denial of
  service. (CVE-2008-1612)
  
  Users of squid are advised to upgrade to these updated packages, which
  contain a backported patch to resolve this issue.


  Affected Software/OS:
  squid on Red Hat Enterprise Linux AS (Advanced Server) version 2.1,
  Red Hat Enterprise Linux ES version 2.1,
  Red Hat Enterprise Linux AS version 3,
  Red Hat Enterprise Linux ES version 3,
  Red Hat Enterprise Linux WS version 3,
  Red Hat Enterprise Linux AS version 4,
  Red Hat Enterprise Linux ES version 4,
  Red Hat Enterprise Linux WS version 4,
  Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-April/msg00009.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of squid");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_2.1")
{

  if(isrpmvuln(pkg:"squid", rpm:"squid~2.4.STABLE7~1.21as.12", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"squid", rpm:"squid~2.6.STABLE6~5.el5_1.3", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"squid-debuginfo", rpm:"squid-debuginfo~2.6.STABLE6~5.el5_1.3", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "RHENT_4")
{

  if(isrpmvuln(pkg:"squid", rpm:"squid~2.5.STABLE14~1.4E.el4_6.2", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"squid-debuginfo", rpm:"squid-debuginfo~2.5.STABLE14~1.4E.el4_6.2", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "RHENT_3")
{

  if(isrpmvuln(pkg:"squid", rpm:"squid~2.5.STABLE3~9.3E", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"squid-debuginfo", rpm:"squid-debuginfo~2.5.STABLE3~9.3E", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}