###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for firefox RHSA-2008:0569-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870117);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0569-01");
  script_cve_id("CVE-2008-2798", "CVE-2008-2799", "CVE-2008-2800", "CVE-2008-2801", "CVE-2008-2802", "CVE-2008-2803", "CVE-2008-2805", "CVE-2008-2807", "CVE-2008-2808", "CVE-2008-2809", "CVE-2008-2810", "CVE-2008-2811");
  script_name(english: "RedHat Update for firefox RHSA-2008:0569-01");
  desc["english"] = "

  Vulnerability Insight:
  Mozilla Firefox is an open source Web browser.
  
  Multiple flaws were found in the processing of malformed JavaScript
  content. A web page containing such malicious content could cause Firefox
  to crash or, potentially, execute arbitrary code as the user running
  Firefox. (CVE-2008-2801, CVE-2008-2802, CVE-2008-2803)
  
  Several flaws were found in the processing of malformed web content. A web
  page containing malicious content could cause Firefox to crash or,
  potentially, execute arbitrary code as the user running Firefox.
  (CVE-2008-2798, CVE-2008-2799, CVE-2008-2811)
  
  Several flaws were found in the way malformed web content was displayed. A
  web page containing specially-crafted content could potentially trick a
  Firefox user into surrendering sensitive information. (CVE-2008-2800)
  
  Two local file disclosure flaws were found in Firefox. A web page
  containing malicious content could cause Firefox to reveal the contents of
  a local file to a remote attacker. (CVE-2008-2805, CVE-2008-2810)
  
  A flaw was found in the way a malformed .properties file was processed by
  Firefox. A malicious extension could read uninitialized memory, possibly
  leaking sensitive data to the extension. (CVE-2008-2807)
  
  A flaw was found in the way Firefox escaped a listing of local file names.
  If a user could be tricked into listing a local directory containing
  malicious file names, arbitrary JavaScript could be run with the
  permissions of the user running Firefox. (CVE-2008-2808)
  
  A flaw was found in the way Firefox displayed information about self-signed
  certificates. It was possible for a self-signed certificate to contain
  multiple alternate name entries, which were not all displayed to the user,
  allowing them to mistakenly extend trust to an unknown site.
  (CVE-2008-2809)
  
  All Mozilla Firefox users should upgrade to these updated packages, which
  contain backported patches that correct these issues.


  Affected Software/OS:
  firefox on Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-July/msg00002.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"devhelp", rpm:"devhelp~0.12~17.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"devhelp-debuginfo", rpm:"devhelp-debuginfo~0.12~17.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"devhelp-devel", rpm:"devhelp-devel~0.12~17.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"firefox", rpm:"firefox~3.0~2.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"firefox-debuginfo", rpm:"firefox-debuginfo~3.0~2.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xulrunner", rpm:"xulrunner~1.9~1.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xulrunner-debuginfo", rpm:"xulrunner-debuginfo~1.9~1.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xulrunner-devel", rpm:"xulrunner-devel~1.9~1.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xulrunner-devel-unstable", rpm:"xulrunner-devel-unstable~1.9~1.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"yelp", rpm:"yelp~2.16.0~19.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"yelp-debuginfo", rpm:"yelp-debuginfo~2.16.0~19.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}