###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_baofeng_storm_activex_ctrl_bof_vuln.nasl 2255 2009-05-12 13:57:21Z may $
#
# BaoFeng Storm ActiveX Control Buffer Overflow Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800570);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1612");
  script_bugtraq_id(34789);
  script_name(english:"BaoFeng Storm ActiveX Control Buffer Overflow Vulnerability");
  desc["english"] = "

  Overview: This host is installed with BaoFeng Storm ActiveX and is prone to
  Buffer Overflow vulnerability.

  Vulnerability Insight:
  A boundary error in the MPS.StormPlayer.1 ActiveX control (mps.dll) while
  processing overly large argument passed to the 'OnBeforeVideoDownload()'
  method leads to buffer overflow.

  Impact:
  Attacker may exploit this issue to execute arbitrary script code and may cause
  denial of service.

  Impact Level: Application

  Affected Software/OS:
  BaoFeng Storm mps.dll version 3.9.4.27 and prior on Windows.

  Fix: Upgarde to the latest BaoFeng Storm version 3.9.05.10
  http://bbs.baofeng.com/read.php?tid=121630

  References:
  http://milw0rm.com/exploits/8579
  http://secunia.com/advisories/34944

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C) 
    CVSS Temporal Score : 8.0 
  Risk factor :High"; 
 
  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of BaoFeng Storm ActiveX");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Buffer overflow");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

stormPath = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                                  "\Uninstall\Storm2", item:"DisplayIcon");
if(!stormPath){
  exit(0);
}

stormPath = stormPath - "Storm.exe" + "mps.dll";
share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:stormPath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:stormPath);

stormdllVer = GetVer(share:share, file:file);

# Check for version of mps.dll
if(stormdllVer != NULL)
{
  if(version_is_less_equal(version:stormdllVer, test_version:"3.9.4.27")){
    security_hole(0);
  }
}
