###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for gnome-python2-extras FEDORA-2008-1435
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860802);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-1435");
  script_cve_id("CVE-2008-0412", "CVE-2008-0413", "CVE-2008-0415", "CVE-2008-0419", "CVE-2008-0591", "CVE-2008-0593", "CVE-2008-0417", "CVE-2008-0418", "CVE-2008-0592", "CVE-2008-0414", "CVE-2008-0594");
  script_name(english: "Fedora Update for gnome-python2-extras FEDORA-2008-1435");
  desc["english"] = "

  Vulnerability Insight:
  The gnome-python-extra package contains the source packages for additional
  Python bindings for GNOME. It should be used together with gnome-python.


  Affected Software/OS:
  gnome-python2-extras on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-February/msg00277.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of gnome-python2-extras");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"gnome-python2-extras", rpm:"gnome-python2-extras~2.14.3~8.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}