###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for IPSec HPSBUX02076
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835109);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "02076");
  script_cve_id("");
  script_name(english: "HP-UX Update for IPSec HPSBUX02076");
  desc["english"] = "

  Vulnerability Insight:
  Potential vulnerabilities have been identified with HP-UX running 
  IPSec.<brThese vulnerabilities may be exploited remotely by an unauthorized 
  user<brto create a Denial of Service (DoS). 

  Impact:
  

  Affected Software/OS:
  IPSec on
  HP-UX B.11.00, B.11.11, and B.11.23 running IPSec. 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00555601-2

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of IPSec");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"IPSec.IPSEC2-KRN", revision:"A.01.05.01", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"IPSec.IPSEC2-KRN", revision:"A.02.01", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"IPSec.IPSEC2-KRN", revision:"A.01.07.02", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"IPSec.IPSEC2-KRN", revision:"A.02.01", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}