###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for avahi MDKSA-2007:185 (avahi)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830120);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:185");
  script_cve_id("CVE-2007-3372");
  script_name(english: "Mandriva Update for avahi MDKSA-2007:185 (avahi)");
  desc["english"] = "

  Vulnerability Insight:

  The Avahi daemon in 0.6.20 and previous allows attackers to cause a
  denial of service via empty TXT data over D-Bus, which triggers an
  assert error.
  
  Updated packages have been patched to prevent this issue.

  Affected Software/OS:
  avahi on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-09/msg00016.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of avahi");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"avahi", rpm:"avahi~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"avahi-dnsconfd", rpm:"avahi-dnsconfd~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"avahi-python", rpm:"avahi-python~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"avahi-sharp", rpm:"avahi-sharp~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"avahi-sharp-doc", rpm:"avahi-sharp-doc~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"avahi-x11", rpm:"avahi-x11~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libavahi-client3", rpm:"libavahi-client3~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libavahi-client3-devel", rpm:"libavahi-client3-devel~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libavahi-common3", rpm:"libavahi-common3~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libavahi-common3-devel", rpm:"libavahi-common3-devel~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libavahi-compat-howl0", rpm:"libavahi-compat-howl0~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libavahi-compat-howl0-devel", rpm:"libavahi-compat-howl0-devel~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libavahi-compat-libdns_sd1", rpm:"libavahi-compat-libdns_sd1~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libavahi-compat-libdns_sd1-devel", rpm:"libavahi-compat-libdns_sd1-devel~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libavahi-core5", rpm:"libavahi-core5~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libavahi-core5-devel", rpm:"libavahi-core5-devel~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libavahi-glib1", rpm:"libavahi-glib1~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libavahi-glib1-devel", rpm:"libavahi-glib1-devel~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libavahi-qt3_1", rpm:"libavahi-qt3_1~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libavahi-qt3_1-devel", rpm:"libavahi-qt3_1-devel~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libavahi-qt4_1", rpm:"libavahi-qt4_1~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libavahi-qt4_1-devel", rpm:"libavahi-qt4_1-devel~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64avahi-client3", rpm:"lib64avahi-client3~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64avahi-client3-devel", rpm:"lib64avahi-client3-devel~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64avahi-common3", rpm:"lib64avahi-common3~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64avahi-common3-devel", rpm:"lib64avahi-common3-devel~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64avahi-compat-howl0", rpm:"lib64avahi-compat-howl0~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64avahi-compat-howl0-devel", rpm:"lib64avahi-compat-howl0-devel~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64avahi-compat-libdns_sd1", rpm:"lib64avahi-compat-libdns_sd1~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64avahi-compat-libdns_sd1-devel", rpm:"lib64avahi-compat-libdns_sd1-devel~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64avahi-core5", rpm:"lib64avahi-core5~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64avahi-core5-devel", rpm:"lib64avahi-core5-devel~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64avahi-glib1", rpm:"lib64avahi-glib1~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64avahi-glib1-devel", rpm:"lib64avahi-glib1-devel~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64avahi-qt3_1", rpm:"lib64avahi-qt3_1~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64avahi-qt3_1-devel", rpm:"lib64avahi-qt3_1-devel~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64avahi-qt4_1", rpm:"lib64avahi-qt4_1~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64avahi-qt4_1-devel", rpm:"lib64avahi-qt4_1-devel~0.6.17~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"avahi", rpm:"avahi~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"avahi-dnsconfd", rpm:"avahi-dnsconfd~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"avahi-python", rpm:"avahi-python~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"avahi-sharp", rpm:"avahi-sharp~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"avahi-x11", rpm:"avahi-x11~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libavahi-client3", rpm:"libavahi-client3~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libavahi-client3-devel", rpm:"libavahi-client3-devel~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libavahi-common3", rpm:"libavahi-common3~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libavahi-common3-devel", rpm:"libavahi-common3-devel~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libavahi-compat-howl0", rpm:"libavahi-compat-howl0~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libavahi-compat-howl0-devel", rpm:"libavahi-compat-howl0-devel~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libavahi-compat-libdns_sd1", rpm:"libavahi-compat-libdns_sd1~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libavahi-compat-libdns_sd1-devel", rpm:"libavahi-compat-libdns_sd1-devel~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libavahi-core4", rpm:"libavahi-core4~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libavahi-core4-devel", rpm:"libavahi-core4-devel~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libavahi-glib1", rpm:"libavahi-glib1~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libavahi-glib1-devel", rpm:"libavahi-glib1-devel~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libavahi-qt3_1", rpm:"libavahi-qt3_1~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libavahi-qt3_1-devel", rpm:"libavahi-qt3_1-devel~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libavahi-qt4_1", rpm:"libavahi-qt4_1~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libavahi-qt4_1-devel", rpm:"libavahi-qt4_1-devel~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64avahi-client3", rpm:"lib64avahi-client3~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64avahi-client3-devel", rpm:"lib64avahi-client3-devel~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64avahi-common3", rpm:"lib64avahi-common3~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64avahi-common3-devel", rpm:"lib64avahi-common3-devel~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64avahi-compat-howl0", rpm:"lib64avahi-compat-howl0~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64avahi-compat-howl0-devel", rpm:"lib64avahi-compat-howl0-devel~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64avahi-compat-libdns_sd1", rpm:"lib64avahi-compat-libdns_sd1~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64avahi-compat-libdns_sd1-devel", rpm:"lib64avahi-compat-libdns_sd1-devel~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64avahi-core4", rpm:"lib64avahi-core4~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64avahi-core4-devel", rpm:"lib64avahi-core4-devel~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64avahi-glib1", rpm:"lib64avahi-glib1~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64avahi-glib1-devel", rpm:"lib64avahi-glib1-devel~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64avahi-qt3_1", rpm:"lib64avahi-qt3_1~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64avahi-qt3_1-devel", rpm:"lib64avahi-qt3_1-devel~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64avahi-qt4_1", rpm:"lib64avahi-qt4_1~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64avahi-qt4_1-devel", rpm:"lib64avahi-qt4_1-devel~0.6.13~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}