###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for libid3tag MDVSA-2008:103 (libid3tag)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830656);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:103");
  script_cve_id("CVE-2008-2109");
  script_name(english: "Mandriva Update for libid3tag MDVSA-2008:103 (libid3tag)");
  desc["english"] = "

  Vulnerability Insight:

  field.c in the libid3tag 0.15.0b library allows context-dependent
  attackers to cause a denial of service (CPU and memory consumption)
  via an ID3_FIELD_TYPE_STRINGLIST field that ends in '\0', which
  triggers an infinite loop.
  
  The updated packages have been patched to correct this.

  Affected Software/OS:
  libid3tag on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64,
  Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-05/msg00021.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of libid3tag");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"libid3tag0", rpm:"libid3tag0~0.15.1b~6.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libid3tag0-devel", rpm:"libid3tag0-devel~0.15.1b~6.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libid3tag", rpm:"libid3tag~0.15.1b~6.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64id3tag0", rpm:"lib64id3tag0~0.15.1b~6.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64id3tag0-devel", rpm:"lib64id3tag0-devel~0.15.1b~6.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"libid3tag0", rpm:"libid3tag0~0.15.1b~6.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libid3tag-devel", rpm:"libid3tag-devel~0.15.1b~6.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libid3tag", rpm:"libid3tag~0.15.1b~6.1mdv2008.0", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64id3tag0", rpm:"lib64id3tag0~0.15.1b~6.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64id3tag-devel", rpm:"lib64id3tag-devel~0.15.1b~6.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}