###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for koffice MDVSA-2008:197-1 (koffice)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830514);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:197-1");
  script_cve_id("CVE-2008-1693");
  script_name(english: "Mandriva Update for koffice MDVSA-2008:197-1 (koffice)");
  desc["english"] = "

  Vulnerability Insight:

  Kees Cook of Ubuntu security found a flaw in how poppler prior
  to version 0.6 displayed malformed fonts embedded in PDF files.
  An attacker could create a malicious PDF file that would cause
  applications using poppler to crash, or possibly execute arbitrary
  code when opened (CVE-2008-1693).
  
  This vulnerability also affected KOffice, so the updated packages
  have been patched to correct this issue.
  
  Update:
  
  A file conflicts existed between one of the library packages and
  the koffice-devel package which prevented successful upgrades if
  koffice-devel was previously installed.  This update removes the
  conflicting file from koffice-devel.

  Affected Software/OS:
  koffice on Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-09/msg00025.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of koffice");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"koffice", rpm:"koffice~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-common", rpm:"koffice-common~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-devel", rpm:"koffice-devel~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-karbon", rpm:"koffice-karbon~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kchart", rpm:"koffice-kchart~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kexi", rpm:"koffice-kexi~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kformula", rpm:"koffice-kformula~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kivio", rpm:"koffice-kivio~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-koshell", rpm:"koffice-koshell~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kplato", rpm:"koffice-kplato~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kpresenter", rpm:"koffice-kpresenter~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-krita", rpm:"koffice-krita~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kspread", rpm:"koffice-kspread~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kugar", rpm:"koffice-kugar~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kword", rpm:"koffice-kword~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-common", rpm:"libkoffice2-common~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-karbon", rpm:"libkoffice2-karbon~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kchart", rpm:"libkoffice2-kchart~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kexi", rpm:"libkoffice2-kexi~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kformula", rpm:"libkoffice2-kformula~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kivio", rpm:"libkoffice2-kivio~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kpresenter", rpm:"libkoffice2-kpresenter~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-krita", rpm:"libkoffice2-krita~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kspread", rpm:"libkoffice2-kspread~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kugar", rpm:"libkoffice2-kugar~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkoffice2-kword", rpm:"libkoffice2-kword~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-common", rpm:"lib64koffice2-common~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-karbon", rpm:"lib64koffice2-karbon~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kchart", rpm:"lib64koffice2-kchart~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kexi", rpm:"lib64koffice2-kexi~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kformula", rpm:"lib64koffice2-kformula~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kivio", rpm:"lib64koffice2-kivio~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kpresenter", rpm:"lib64koffice2-kpresenter~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-krita", rpm:"lib64koffice2-krita~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kspread", rpm:"lib64koffice2-kspread~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kugar", rpm:"lib64koffice2-kugar~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64koffice2-kword", rpm:"lib64koffice2-kword~1.6.3~19.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}