###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_openssl_mult_vuln_lin.nasl 1258 2009-04-01 13:20:29Z apr $
#
# OpenSSL Multiple Vulnerabilities (Linux)
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800259);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0590", "CVE-2009-0591", "CVE-2009-0789");
  script_bugtraq_id(34256);
  script_name(english:"OpenSSL Multiple Vulnerabilities (Linux)");
  desc["english"] = "

  Overview: This host is installed with OpenSSL and is prone to Multiple
  Vulnerabilities.

  Vulnerability Insight:
  - error exists in the 'ASN1_STRING_print_ex()' function when printing
    'BMPString' or 'UniversalString' strings which causes invalid memory
    access violation.
  - 'CMS_verify' function incorrectly handles an error condition when
    processing malformed signed attributes.
  - error when processing malformed 'ASN1' structures which causes invalid
    memory access violation.

  Impact:
  Successful exploitation will let the attacker cause memory access violation,
  security bypass or can cause denial of service.

  Affected Software/OS:
  OpenSSL version prior to 0.9.8k on all running platform.

  Fix:
  Upgrade to OpenSSL version 0.9.8k
  http://openssl.org

  References:
  http://secunia.com/advisories/34411
  http://www.openssl.org/news/secadv_20090325.txt
  http://securitytracker.com/alerts/2009/Mar/1021905.html

  CVSS Score:
    CVSS Base Score     : 6.4 (AV:N/AC:L/Au:NR/C:N/I:P/A:P)
    CVSS Temporal Score : 4.7
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of OpenSSL");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Denial of Service");
  script_dependencies("gb_openssl_detect_lin.nasl");
  script_require_keys("OpenSSL/Linux/Ver");
  exit(0);
}


include("version_func.inc");

opensslVer = get_kb_item("OpenSSL/Linux/Ver");
if(!opensslVer){
  exit(0);
}

# Grep for OpenSSL version prior to 0.9.8k
if(version_is_less(version:opensslVer, test_version:"0.9.8k")){
  security_warning(0);
}
