###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for Xorg and XFree SUSE-SA:2008:003
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850025);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2008-003");
  script_cve_id("CVE-2007-5760", "CVE-2007-5958", "CVE-2007-6427", "CVE-2007-6428", "CVE-2007-6429", "CVE-2008-0006");
  script_name(english: "SuSE Update for Xorg and XFree SUSE-SA:2008:003");
  desc["english"] = "

  Vulnerability Insight:

  The X windows system is vulnerable to several kind of vulner-
  abilities that are caused due to insufficient input validation.

  The bugs range from crashing the X server to executing arbitrary
  code with the privilges of the X server process.

  For a successful attack the opponent needs shell access to the
  vulnerable system (local) or an already established connection
  to the X server.

  Thanks to US CERT and iDefense for reporting this vulnerabilities
  and to the Xorg-Security folks for fixing it.

  The Fixes are:
  - CVE-2007-5760: XFree86 Misc extension out of bounds array index
  - CVE-2007-5958: File existence disclosure
  - CVE-2007-6427: Xinput extension memory corruption
  - CVE-2007-6428: TOG-cup extension memory corruption
  - CVE-2007-6429: MIT-SHM and EVI extensions integer overflows
  - CVE-2008-0006: PCF Font parser buffer overflow

  Impact:
  remote code execution

  Affected Software/OS:
  Xorg and XFree on SUSE LINUX 10.1, openSUSE 10.2, openSUSE 10.3, SuSE Linux Enterprise Server 8, SUSE SLES 9, Novell Linux Desktop 9, Open Enterprise Server, Novell Linux POS 9, SUSE Linux Enterprise Desktop 10 SP1, SLE SDK 10 SP1, SUSE Linux Enterprise Server 10 SP1

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/xorg_sec_prob.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of Xorg and XFree");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.3")
{

  if(isrpmvuln(pkg:"xorg-x11-devel", rpm:"xorg-x11-devel~7.2~103.4", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-libs", rpm:"xorg-x11-libs~7.2~103.4", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-server", rpm:"xorg-x11-server~7.2~143.9", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-server-extra", rpm:"xorg-x11-server-extra~7.2~143.9", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-server-sdk", rpm:"xorg-x11-server-sdk~7.2~143.9", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-devel-32bit", rpm:"xorg-x11-devel-32bit~7.2~103.4", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-libs-32bit", rpm:"xorg-x11-libs-32bit~7.2~103.4", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"xorg-x11-devel", rpm:"xorg-x11-devel~7.2~25", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-libs", rpm:"xorg-x11-libs~7.2~25", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-server", rpm:"xorg-x11-server~7.2~30.11", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-server-sdk", rpm:"xorg-x11-server-sdk~7.2~30.11", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-devel-32bit", rpm:"xorg-x11-devel-32bit~7.2~25", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-libs-32bit", rpm:"xorg-x11-libs-32bit~7.2~25", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDK10SP1")
{

  if(isrpmvuln(pkg:"xorg-x11-Xvfb", rpm:"xorg-x11-Xvfb~6.9.0~50.54.5", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-Xnest", rpm:"xorg-x11-Xnest~6.9.0~50.54.5", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "OES")
{

  if(isrpmvuln(pkg:"XFree86-Xnest", rpm:"XFree86-Xnest~4.3.99.902~43.94", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-Xvfb", rpm:"XFree86-Xvfb~4.3.99.902~43.94", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-libs", rpm:"XFree86-libs~4.3.99.902~43.94", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-server", rpm:"XFree86-server~4.3.99.902~43.94", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES9")
{

  if(isrpmvuln(pkg:"XFree86-Xnest", rpm:"XFree86-Xnest~4.3.99.902~43.94", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-Xvfb", rpm:"XFree86-Xvfb~4.3.99.902~43.94", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-libs", rpm:"XFree86-libs~4.3.99.902~43.94", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-server", rpm:"XFree86-server~4.3.99.902~43.94", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLDk9")
{

  if(isrpmvuln(pkg:"XFree86-Xnest", rpm:"XFree86-Xnest~4.3.99.902~43.94", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-Xvfb", rpm:"XFree86-Xvfb~4.3.99.902~43.94", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-libs", rpm:"XFree86-libs~4.3.99.902~43.94", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-server", rpm:"XFree86-server~4.3.99.902~43.94", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDk10SP1")
{

  if(isrpmvuln(pkg:"xorg-x11-Xvfb", rpm:"xorg-x11-Xvfb~6.9.0~50.54.5", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-Xnest", rpm:"xorg-x11-Xnest~6.9.0~50.54.5", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-libs-32bit", rpm:"xorg-x11-libs-32bit~6.9.0~50.54.5", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-libs", rpm:"xorg-x11-libs~6.9.0~50.54.5", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-server", rpm:"xorg-x11-server~6.9.0~50.54.5", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"xorg-x11-Xnest", rpm:"xorg-x11-Xnest~6.9.0~50.54.5", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-Xvfb", rpm:"xorg-x11-Xvfb~6.9.0~50.54.5", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-devel", rpm:"xorg-x11-devel~6.9.0~50.54.5", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-libs", rpm:"xorg-x11-libs~6.9.0~50.54.5", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"xorg-x11-server", rpm:"xorg-x11-server~6.9.0~50.54.5", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLPOS9")
{

  if(isrpmvuln(pkg:"XFree86-Xnest", rpm:"XFree86-Xnest~4.3.99.902~43.94", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-Xvfb", rpm:"XFree86-Xvfb~4.3.99.902~43.94", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-libs", rpm:"XFree86-libs~4.3.99.902~43.94", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"XFree86-server", rpm:"XFree86-server~4.3.99.902~43.94", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}