###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for samba regression USN-544-2
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840097);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "544-2");
  script_cve_id("CVE-2007-4572", "CVE-2007-5398");
  script_name(english: "Ubuntu Update for samba regression USN-544-2");
  desc["english"] = "

  Vulnerability Insight:

  USN-544-1 fixed two vulnerabilities in Samba. Fixes for CVE-2007-5398
  are unchanged, but the upstream changes for CVE-2007-4572 introduced a
  regression in all releases which caused Linux smbfs mounts to fail.
  Additionally, Dapper and Edgy included an incomplete patch which caused
  configurations using NetBIOS to fail. A proper fix for these regressions
  does not exist at this time, and so the patch addressing CVE-2007-4572
  has been removed. This vulnerability is believed to be an unexploitable
  denial of service, but a future update will address this issue. We
  apologize for the inconvenience.
  
  Original advisory details:
  
  Samba developers discovered that nmbd could be made to overrun
  a buffer during the processing of GETDC logon server requests.
  When samba is configured as a Primary or Backup Domain Controller,
  a remote attacker could send malicious logon requests and possibly
  cause a denial of service. (CVE-2007-4572)
  
  Alin Rad Pop of Secunia Research discovered that nmbd did not properly
  check the length of netbios packets. When samba is configured as a WINS
  server, a remote attacker could send multiple crafted requests resulting
  in the execution of arbitrary code with root privileges. (CVE-2007-5398)

  Affected Software/OS:
  samba regression on Ubuntu 6.06 LTS ,
  Ubuntu 6.10 ,
  Ubuntu 7.04 ,
  Ubuntu 7.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-November/000626.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of samba regression");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"libpam-smbpass", ver:"3.0.24-2ubuntu1.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libsmbclient-dev", ver:"3.0.24-2ubuntu1.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libsmbclient", ver:"3.0.24-2ubuntu1.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-samba", ver:"3.0.24-2ubuntu1.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-common", ver:"3.0.24-2ubuntu1.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-dbg", ver:"3.0.24-2ubuntu1.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba", ver:"3.0.24-2ubuntu1.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"smbclient", ver:"3.0.24-2ubuntu1.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"smbfs", ver:"3.0.24-2ubuntu1.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"swat", ver:"3.0.24-2ubuntu1.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"winbind", ver:"3.0.24-2ubuntu1.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-doc-pdf", ver:"3.0.24-2ubuntu1.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-doc", ver:"3.0.24-2ubuntu1.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"libpam-smbpass", ver:"3.0.22-1ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libsmbclient-dev", ver:"3.0.22-1ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libsmbclient", ver:"3.0.22-1ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4-samba", ver:"3.0.22-1ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-common", ver:"3.0.22-1ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-dbg", ver:"3.0.22-1ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba", ver:"3.0.22-1ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"smbclient", ver:"3.0.22-1ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"smbfs", ver:"3.0.22-1ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"swat", ver:"3.0.22-1ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"winbind", ver:"3.0.22-1ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-doc-pdf", ver:"3.0.22-1ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-doc", ver:"3.0.22-1ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"libpam-smbpass", ver:"3.0.22-1ubuntu4.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libsmbclient-dev", ver:"3.0.22-1ubuntu4.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libsmbclient", ver:"3.0.22-1ubuntu4.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4-samba", ver:"3.0.22-1ubuntu4.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-common", ver:"3.0.22-1ubuntu4.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-dbg", ver:"3.0.22-1ubuntu4.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba", ver:"3.0.22-1ubuntu4.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"smbclient", ver:"3.0.22-1ubuntu4.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"smbfs", ver:"3.0.22-1ubuntu4.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"swat", ver:"3.0.22-1ubuntu4.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"winbind", ver:"3.0.22-1ubuntu4.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-doc-pdf", ver:"3.0.22-1ubuntu4.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-doc", ver:"3.0.22-1ubuntu4.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"libpam-smbpass", ver:"3.0.26a-1ubuntu2.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libsmbclient-dev", ver:"3.0.26a-1ubuntu2.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libsmbclient", ver:"3.0.26a-1ubuntu2.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-common", ver:"3.0.26a-1ubuntu2.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-dbg", ver:"3.0.26a-1ubuntu2.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba", ver:"3.0.26a-1ubuntu2.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"smbclient", ver:"3.0.26a-1ubuntu2.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"smbfs", ver:"3.0.26a-1ubuntu2.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"swat", ver:"3.0.26a-1ubuntu2.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"winbind", ver:"3.0.26a-1ubuntu2.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-doc-pdf", ver:"3.0.26a-1ubuntu2.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"samba-doc", ver:"3.0.26a-1ubuntu2.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}