###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for webkit vulnerability USN-676-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840221);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "676-1");
  script_cve_id("CVE-2008-3632");
  script_name(english: "Ubuntu Update for webkit vulnerability USN-676-1");
  desc["english"] = "

  Vulnerability Insight:

  It was discovered that WebKit did not properly handle Cascading Style Sheets
  (CSS) import statements. If a user were tricked into opening a malicious
  website, an attacker could cause a browser crash and possibly execute
  arbitrary code with user privileges.

  Affected Software/OS:
  webkit vulnerability on Ubuntu 8.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-November/000786.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of webkit vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"libwebkit", ver:"1.0-1-dbg_1.0.1-2ubuntu0.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libwebkit", ver:"1.0-1_1.0.1-2ubuntu0.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libwebkit-dev", ver:"1.0.1-2ubuntu0.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}