# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory MDVSA-2009:051 (libpng)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63440);
 script_cve_id("CVE-2008-3964", "CVE-2008-5907", "CVE-2009-0040");
 script_version ("$");
 name["english"] = "Mandrake Security Advisory MDVSA-2009:051 (libpng)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to libpng
announced via advisory MDVSA-2009:051.

A number of vulnerabilities have been found and corrected in libpng:

Fixed 1-byte buffer overflow in pngpread.c (CVE-2008-3964). This was
allready fixed in Mandriva Linux 2009.0.

Fix the function png_check_keyword() that allowed setting arbitrary
bytes in the process memory to 0 (CVE-2008-5907).

Fix a potential DoS (Denial of Service) or to potentially compromise
an application using the library (CVE-2009-0040).

The updated packages have been patched to prevent this.

Affected: 2008.0, 2008.1, 2009.0, Corporate 3.0, Corporate 4.0,
          Multi Network Firewall 2.0


Solution:
To upgrade automatically use MandrakeUpdate or urpmi.  The verification
of md5 checksums and GPG signatures is performed automatically for you.

https://secure1.securityspace.com/smysecure/catid.html?in=MDVSA-2009:051

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Mandrake Security Advisory MDVSA-2009:051 (libpng)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"libpng3", rpm:"libpng3~1.2.22~0.3mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng-devel", rpm:"libpng-devel~1.2.22~0.3mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng-source", rpm:"libpng-source~1.2.22~0.3mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng-static-devel", rpm:"libpng-static-devel~1.2.22~0.3mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64png3", rpm:"lib64png3~1.2.22~0.3mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64png-devel", rpm:"lib64png-devel~1.2.22~0.3mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64png-static-devel", rpm:"lib64png-static-devel~1.2.22~0.3mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng3", rpm:"libpng3~1.2.25~2.2mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng-devel", rpm:"libpng-devel~1.2.25~2.2mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng-source", rpm:"libpng-source~1.2.25~2.2mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng-static-devel", rpm:"libpng-static-devel~1.2.25~2.2mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64png3", rpm:"lib64png3~1.2.25~2.2mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64png-devel", rpm:"lib64png-devel~1.2.25~2.2mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64png-static-devel", rpm:"lib64png-static-devel~1.2.25~2.2mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng3", rpm:"libpng3~1.2.31~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng-devel", rpm:"libpng-devel~1.2.31~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng-source", rpm:"libpng-source~1.2.31~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng-static-devel", rpm:"libpng-static-devel~1.2.31~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64png3", rpm:"lib64png3~1.2.31~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64png-devel", rpm:"lib64png-devel~1.2.31~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64png-static-devel", rpm:"lib64png-static-devel~1.2.31~2.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng3", rpm:"libpng3~1.2.5~10.11.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng3-devel", rpm:"libpng3-devel~1.2.5~10.11.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng3-static-devel", rpm:"libpng3-static-devel~1.2.5~10.11.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64png3", rpm:"lib64png3~1.2.5~10.11.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64png3-devel", rpm:"lib64png3-devel~1.2.5~10.11.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64png3-static-devel", rpm:"lib64png3-static-devel~1.2.5~10.11.C30mdk", rls:"MNDK_3.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng3", rpm:"libpng3~1.2.8~1.6.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng3-devel", rpm:"libpng3-devel~1.2.8~1.6.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng3-static-devel", rpm:"libpng3-static-devel~1.2.8~1.6.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64png3", rpm:"lib64png3~1.2.8~1.6.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64png3-devel", rpm:"lib64png3-devel~1.2.8~1.6.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64png3-static-devel", rpm:"lib64png3-static-devel~1.2.8~1.6.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng3", rpm:"libpng3~1.2.5~10.11.C30mdk", rls:"MNDK_2.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng3-devel", rpm:"libpng3-devel~1.2.5~10.11.C30mdk", rls:"MNDK_2.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng3-static-devel", rpm:"libpng3-static-devel~1.2.5~10.11.C30mdk", rls:"MNDK_2.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
